/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workflow.store;

import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.spi.WorkflowStore;

/**
 * {@link WorkflowStore} which does not keep instances once they are finished.
 */
public interface AmetysWorkflowStore extends WorkflowStore
{
    /**
     * Returns true if the history steps have to be removed when the workflow reaches its final step
     * @return true if the history history has to be cleared.
     */
    public boolean shouldClearHistory();
    
    /**
     * Deletes a workflow instance from the database.<br>
     * All future calls from the workflow to this instance will failed.
     * @param entryId The id of a workflow instance.
     * @throws StoreException if an error occurs.
     */
    public void deleteInstance(long entryId) throws StoreException;

    /**
     * Removes all history steps of an instance from the database.<br>
     * All future calls to the history will return an empty List of Step.
     * @param entryId the id of a workflow instance.
     * @throws StoreException if an error occurs.
     */
    public void clearHistory(long entryId) throws StoreException;
}
