/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workflow.tool;

import java.io.File;
import java.util.Map;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

import org.ametys.core.ui.StaticClientSideElement;

import net.sourceforge.plantuml.dot.ExeState;
import net.sourceforge.plantuml.dot.GraphvizRuntimeEnvironment;

/**
 * Client side element for the workflow tool.
 */
public class WorkflowToolClientSideElement extends StaticClientSideElement
{
    @Override
    protected Map<String, Object> configureInitialParameters(Configuration configuration) throws ConfigurationException
    {
        Map<String, Object> initialParameters = super.configureInitialParameters(configuration);
        
        // Add an initial parameter to define if graphviz is supported
        File dotExe = GraphvizRuntimeEnvironment.getInstance().getDotExe();
        ExeState exeState = ExeState.checkFile(dotExe);
        initialParameters.put("isGraphvizSupported", exeState == ExeState.OK);
        
        return initialParameters;
    }
}
