/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.calendar.icsreader;

import java.time.ZonedDateTime;
import java.util.Objects;
import org.ametys.plugins.calendar.events.EventsFilterHelper;

public class CacheKey {
    private String _url;
    private Long _nbEvents;
    private ZonedDateTime _fromDate;
    private ZonedDateTime _untilDate;
    private Long _maxFileSize;

    public CacheKey(String url, EventsFilterHelper.DateTimeRange dateRange, Long nbEvents, Long maxFileSize) {
        this._url = url;
        this._nbEvents = nbEvents;
        if (dateRange != null) {
            this._fromDate = dateRange.fromDate();
            this._untilDate = dateRange.untilDate();
        }
        this._maxFileSize = maxFileSize;
    }

    public int hashCode() {
        return Objects.hash(this._untilDate, this._maxFileSize, this._nbEvents, this._fromDate, this._url);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheKey other = (CacheKey)obj;
        return Objects.equals(this._untilDate, other._untilDate) && Objects.equals(this._maxFileSize, other._maxFileSize) && Objects.equals(this._nbEvents, other._nbEvents) && Objects.equals(this._fromDate, other._fromDate) && Objects.equals(this._url, other._url);
    }
}

