<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:date="http://exslt.org/dates-and-times"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:escaper="org.apache.commons.text.StringEscapeUtils"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:exsl="http://exslt.org/common"
                xmlns:math="java.lang.Math"
                xmlns:encoder="java.net.URLEncoder"
                extension-element-prefixes="resolver escaper ametys encoder exsl">
                
    <xsl:import href="service:calendar://pages/services/search/common/common.xsl"/>
    <xsl:import href="view://stylesheets/utils.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">service-calendar</xsl:variable>
    
    <xsl:template name="onload-callback">function(){}</xsl:template>
    <xsl:template name="onselect-callback">function(){}</xsl:template>
    <xsl:template name="datepicker-additional-config">{}</xsl:template>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="calendar-search-service-head-js"/>
        
        <xsl:call-template name="jquery-calendar"/>
    </xsl:template>
    
    <xsl:template name="jquery-calendar">
        <script type="text/javascript">
            
            var date = new Date();
            var fetchInfo<xsl:value-of select="$serviceId"/> = {
                initialized: false,
                events: [],
                start: new Date(date.getFullYear(), date.getMonth(), 1).toISOString(),
                end: new Date(date.getFullYear(), date.getMonth() + 1, 1).toISOString(),
                loadCb: <xsl:call-template name="onload-callback"/>,
                selectCb: <xsl:call-template name="onselect-callback"/>,
            }
            
            function isEventOfDay<xsl:value-of select="$serviceId"/>(dayDate, event)
            {
                var minDay = dayDate.toISOString();
                var nextDay = new Date(dayDate);
                nextDay.setDate(dayDate.getDate() + 1);
                var maxDay = nextDay.toISOString();
                
                if (!event.end &amp;&amp; minDay &lt;= event.start &amp;&amp; event.start &lt; maxDay)
                {
                    return true;
                }
                else if (event.start &lt; maxDay &amp;&amp; minDay &lt; event.end)
                {
                    return true;
                }
            }
            
            function beforeShowDay<xsl:value-of select="$serviceId"/>(date)
            {
                var count = 0;
                var events = fetchInfo<xsl:value-of select="$serviceId"/>.events;
                $j.each(events, function (index, event) {
                
                    if (isEventOfDay<xsl:value-of select="$serviceId"/>(date, event))
                    {
                        count++;
                    }
                });
                
                return [count &gt; 0, '', '<i18n:text i18n:key="CALENDAR_SERVICE_CALENDAR_EVENTS_COUNT"/> ' + count];
            }
            
            function onSelect<xsl:value-of select="$serviceId"/>(dateText, inst)
            {
                fetchInfo<xsl:value-of select="$serviceId"/>.selectedDate = dateText;
                
                var date = $j.datepicker.parseDate('yy-mm-dd', dateText);
                
                var events = fetchInfo<xsl:value-of select="$serviceId"/>.events;
                $j.each(events, function (index, event) {
                
                    if (isEventOfDay<xsl:value-of select="$serviceId"/>(date, event))
                    {
                        $j("[data-event-id='" + event.id + "']").show();
                        $j("[data-event-id='" + event.id + "']").attr("data-event-show", "true");
                    }
                    else
                    {
                        $j("[data-event-id='" + event.id + "']").hide();
                        $j("[data-event-id='" + event.id + "']").attr("data-event-show", "false");
                    }
                })
                
                fetchInfo<xsl:value-of select="$serviceId"/>.selectCb();
            }
            
            function loadEvents<xsl:value-of select="$serviceId"/>()
            {
                var start = fetchInfo<xsl:value-of select="$serviceId"/>.start;
                var end = fetchInfo<xsl:value-of select="$serviceId"/>.end;
                
                CalendarSearchService.launchSearch({
                       selector: "#calendar-search-service-<xsl:value-of select="$serviceId"/>",
                       siteUriPrefix: "<xsl:value-of select="$site-uri-prefix"/>",
                       zoneItemId: "<xsl:value-of select="/search/zone-item/@id"/>",
                       siteName: "<xsl:value-of select="$site"/>",
                       lang: "<xsl:value-of select="$lang"/>",
                       isSubmit: true
                    }, 
                    start, 
                    end,
                    function() {
                        // on success
                        var results = JSON.parse($j('#calendar-search-service-<xsl:value-of select="$serviceId"/> [data-ametys-search-role="search-results"] [data-ametys-search-role="json-hits"]').html());
                        fetchInfo<xsl:value-of select="$serviceId"/>.events = results.events;
                        
                        if (!fetchInfo<xsl:value-of select="$serviceId"/>.initalized)
                        {
                            var datePickerConf = $.extend({
                                <!-- Date format -->
                                dateFormat: 'yy-mm-dd',
                            
                                beforeShowDay: beforeShowDay<xsl:value-of select="$serviceId"/>,
                                onSelect: onSelect<xsl:value-of select="$serviceId"/>,
                                onChangeMonthYear: onChangeMonthYear<xsl:value-of select="$serviceId"/>
                            }, <xsl:call-template name="datepicker-additional-config"/>);
                            
                            // Create date picker
                            $j("#calendar-<xsl:value-of select="$serviceId"/>").datepicker(datePickerConf);
                            
                            fetchInfo<xsl:value-of select="$serviceId"/>.initalized = true;
                            
                            // Trigger select event
                            $j('#calendar-<xsl:value-of select="$serviceId"/> .ui-state-active').trigger('click');
                        }
                        else
                        {
                            // Refresh datepricker
                            $j("#calendar-<xsl:value-of select="$serviceId"/>").datepicker( "refresh" );
                        }
                        
                        if (fetchInfo<xsl:value-of select="$serviceId"/>.selectedDate)
                        {
                            // trigger select event
                            $j('#calendar-<xsl:value-of select="$serviceId"/>').datepicker( "setDate", fetchInfo<xsl:value-of select="$serviceId"/>.selectedDate)
                            $j('#calendar-<xsl:value-of select="$serviceId"/> .ui-state-active').trigger('click');
                        }
                        
                        fetchInfo<xsl:value-of select="$serviceId"/>.loadCb();
                    },
                    function() {
                        // Nothing
                    }
                );
            }
            
            function onChangeMonthYear<xsl:value-of select="$serviceId"/>(year, month, inst)
            {
                fetchInfo<xsl:value-of select="$serviceId"/>.start = new Date(year, month - 1, 1).toISOString();
                fetchInfo<xsl:value-of select="$serviceId"/>.end = new Date(year, month, 1).toISOString();
             
                // reset selected date
                fetchInfo<xsl:value-of select="$serviceId"/>.selectedDate = null;
                // load events of the month
                loadEvents<xsl:value-of select="$serviceId"/>();
            }
            
            $j(document).ready(function () {
                
                // Initialize calendar from current date
                loadEvents<xsl:value-of select="$serviceId"/>();
            });
        </script>
    </xsl:template>
    
    <xsl:template name="hits">
        <script type="text/template" data-ametys-search-role="json-hits">
            {
                "events": [<xsl:for-each select="/search/hits/hit">
                                <xsl:apply-templates select="." mode="json"/>
                                <xsl:if test="position() != last()">,</xsl:if>
                           </xsl:for-each>]
            }
        </script>
    
        <xsl:if test="/search/hits/hit">
            <div data-ametys-search-role="hits">
                <ul>
                    <xsl:for-each select="/search/hits/hit">
                        <xsl:apply-templates select="."/>
                   </xsl:for-each>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="hit[content]">
        <li data-event-id="{content/@id}" style="display:none;" data-event-show="false">
            <xsl:copy-of select="content/view/html/body/node()"/>
        </li>
    </xsl:template>
    
    <xsl:template match="hit[@icsEvent='true']">
        <li data-event-id="{id}" style="display:none;" data-event-show="false">
            <a href="{event/url}">
                <span class="title"><xsl:value-of select="event/title"/></span>
                <span class="date">
                    <xsl:call-template name="common-utils-dates">
                        <xsl:with-param name="startDate" select="event/startDate"/>
                        <xsl:with-param name="endDate" select="event/endDate"/>
                    </xsl:call-template>
                </span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="search-js-submit-button">
        <xsl:variable name="code">
            loadEvents<xsl:value-of select="$serviceId"/>();
            return false;
        </xsl:variable>
        <xsl:value-of select="normalize-space($code)"/>
    </xsl:template>
    
</xsl:stylesheet>