/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.calendar.search;

import java.util.List;
import java.util.Map;

import org.ametys.cms.content.indexing.solr.SolrFieldNames;
import org.ametys.cms.search.solr.field.TagSearchField;
import org.ametys.web.frontoffice.search.requesttime.SearchComponent;
import org.ametys.web.frontoffice.search.requesttime.SearchComponentArguments;
import org.ametys.web.frontoffice.search.requesttime.impl.SearchComponentHelper;

/**
 * {@link SearchComponent} to execute search with "allTags" facet
 */
public class TagFacetSearchComponent implements SearchComponent
{
    /** The helper for search component */
    protected SearchComponentHelper _searchComponentHelper;
    
    @Override
    public int priority()
    {
        return SEARCH_PRIORITY - 7000; // same as FacetSearchComponent
    }

    @Override
    public boolean supports(SearchComponentArguments args)
    {
        return CalendarSearchService.isFormSubmit(args) && CalendarSearchService.isActive(args) && CalendarSearchService.hasTagCategories(args.serviceInstance());
    }

    @Override
    public void execute(SearchComponentArguments args) throws Exception
    {
        List<String> selectedTags = CalendarSearchService.getSelectedTags(args);
        
        if (!selectedTags.isEmpty())
        {
            args.searcher().withFacets(new TagSearchField(true));
            args.searcher().withFacetValues(Map.of(SolrFieldNames.ALL_TAGS, selectedTags));
        }
    }
}
