/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.calendar.icsreader;

import java.util.Date;

import org.ametys.cms.tag.Tag;

import net.fortuna.ical4j.model.component.VEvent;

/**
 * A holder created principally for recurrent events, so we can have one iteration of this event, using a start and end date of this iteration
 */
public class LocalVEvent
{
    private VEvent _event;
    
    private Date _start;
    
    private Date _end;
    
    private Tag _tag;
    
    /**
     * Store an event and a start/end date, the currentDay is used when an event is on multiple days, so we know which day is the one used here
     * @param event the event
     * @param start start of the iteration of this event (around the current day)
     * @param end end of the iteration of this event (around the current day)
     * @param tag the tag used for this ICS
     */
    public LocalVEvent(VEvent event, Date start, Date end, Tag tag)
    {
        _event = event;
        _start = start;
        _end = end;
        _tag = tag;
    }

    /**
     * return the event
     * @return the event
     */
    public VEvent getEvent()
    {
        return _event;
    }

    /**
     * return the start date of this iteration
     * @return the start date of this iteration
     */
    public Date getStart()
    {
        return _start;
    }

    /**
     * return the end date of this iteration
     * @return the end date of this iteration
     */
    public Date getEnd()
    {
        return _end;
    }

    /**
     * return the tag used for this ICS
     * @return the tag used for this ICS
     */
    public Tag getTag()
    {
        return _tag;
    }
}
