/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.calendar.events;

import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.IgnoreRootHandler;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.type.ModelItemType;
import org.ametys.web.filter.ContentFilterHelper;
import org.ametys.web.filter.WebContentFilter;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.source.impl.SitemapSource;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractEventGenerator
extends ServiceableGenerator {
    protected SourceResolver _resolver;
    protected ContentFilterHelper _filterHelper;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (SourceResolver)serviceManager.lookup(SourceResolver.ROLE);
        this._filterHelper = (ContentFilterHelper)serviceManager.lookup(ContentFilterHelper.ROLE);
    }

    public void saxContent(ContentHandler handler, Content content, boolean saxContentItSelf, WebContentFilter filter, boolean checkUserAccess) throws SAXException, IOException {
        String end;
        ArrayList<String> params = new ArrayList<String>();
        params.add(content.getTitle());
        AttributesImpl attrs = new AttributesImpl();
        String start = this._getFormatedDateAttribute(content, "start-date");
        if (start != null) {
            params.add(start);
            attrs.addCDATAAttribute("start", start);
        }
        if ((end = this._getFormatedDateAttribute(content, "end-date")) != null) {
            params.add(end);
            attrs.addCDATAAttribute("end", end);
        }
        XMLUtils.startElement((ContentHandler)handler, (String)"event", (Attributes)attrs);
        String key = end == null ? "CALENDAR_SERVICE_AGENDA_EVENT_TITLE_SINGLE_DAY" : "CALENDAR_SERVICE_AGENDA_FROM_TO";
        I18nizableText description = new I18nizableText(null, key, params);
        description.toSAX(handler, "description");
        if (saxContentItSelf) {
            XMLUtils.startElement((ContentHandler)handler, (String)"view");
            this._filterHelper.saxContent(handler, content, filter.getView(), checkUserAccess);
            XMLUtils.endElement((ContentHandler)handler, (String)"view");
        }
        this.saxXMLContent(handler, content, "main");
        if (content instanceof WebContent) {
            WebContent webContent = (WebContent)content;
            XMLUtils.startElement((ContentHandler)handler, (String)"pages");
            Collection pages = webContent.getReferencingPages();
            for (Page page : pages) {
                AttributesImpl atts = new AttributesImpl();
                atts.addCDATAAttribute("id", page.getId());
                atts.addCDATAAttribute("name", page.getName());
                atts.addCDATAAttribute("lang", page.getSitemapName());
                atts.addCDATAAttribute("site", page.getSiteName());
                atts.addCDATAAttribute("path", page.getPathInSitemap());
                atts.addCDATAAttribute("title", page.getTitle());
                XMLUtils.createElement((ContentHandler)handler, (String)"page", (Attributes)atts);
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"pages");
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"event");
    }

    protected String _getFormatedDateAttribute(Content content, String attributePath) {
        ModelItemType attributeType = content.getType(attributePath);
        if ("date".equals(attributeType.getId())) {
            LocalDate date = (LocalDate)content.getValue(attributePath);
            return Optional.ofNullable(date).map(d -> d.format(DateTimeFormatter.ISO_LOCAL_DATE)).orElse(null);
        }
        ZonedDateTime date = (ZonedDateTime)content.getValue(attributePath);
        return Optional.ofNullable(date).map(d -> d.withZoneSameInstant(ZoneId.systemDefault()).format(DateTimeFormatter.ISO_LOCAL_DATE)).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saxXMLContent(ContentHandler handler, Content content, String viewName) throws SAXException, IOException {
        String uri = "cocoon://_content.xml?contentId=" + content.getId() + "&viewName=" + viewName;
        SitemapSource src = null;
        try {
            src = (SitemapSource)this._resolver.resolveURI(uri);
            src.toSAX((ContentHandler)new IgnoreRootHandler(handler));
        }
        finally {
            this._resolver.release((Source)src);
        }
    }
}

