/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.calendar.events;

import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.matching.WildcardURIMatcher;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.commons.lang.StringUtils;

import org.ametys.core.util.URIUtils;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.web.repository.page.ZoneItem;

/**
 * Matcher which retrieves the zone item from its ID in the request URI and sets it as a request attribute.
 */
public class ZoneItemMatcher extends WildcardURIMatcher implements Serviceable
{
    /** The ametys object resolver. */
    protected AmetysObjectResolver _resolver;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        _resolver = (AmetysObjectResolver) manager.lookup(AmetysObjectResolver.ROLE);
    }
    
    @Override
    public Map match(String pattern, Map objectModel, Parameters parameters) throws PatternException
    {
        Map result = super.match(pattern, objectModel, parameters);
        
        String index = parameters.getParameter("zoneItemIndex", "1");
        
        if (result != null && StringUtils.isNotEmpty(index))
        {
            String zoneItemId = (String) result.get(index);
            if (StringUtils.isNotEmpty(zoneItemId))
            {
                String decodedId = URIUtils.decode(zoneItemId);
                
                ZoneItem zoneItem = _resolver.resolveById(decodedId);
                
                Request request = ObjectModelHelper.getRequest(objectModel);
                request.setAttribute(ZoneItem.class.getName(), zoneItem);
            }
        }
        
        return result;
    }
}
