/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.calendar.search;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;

import org.apache.commons.lang3.ObjectUtils;

import org.ametys.cms.search.query.Query;
import org.ametys.web.frontoffice.search.metamodel.AdditionalParameterValueMap;
import org.ametys.web.frontoffice.search.metamodel.Returnable;
import org.ametys.web.frontoffice.search.metamodel.SearchCriterionDefinition;
import org.ametys.web.frontoffice.search.metamodel.Searchable;
import org.ametys.web.frontoffice.search.metamodel.impl.AbstractContentBasedSearchable;

/**
 * {@link Searchable} for contents with a start date
 *
 */
public class CalendarContentSearchable extends AbstractContentBasedSearchable
{
    /** Avalon Role */
    public static final String ROLE = CalendarContentSearchable.class.getName();
    
    /** The prefix for content with date searchable */
    public static final String CRITERION_DEFINITION_PREFIX_ID = "ContentWithDateSearchable$";
    
    public Optional<Query> joinQuery(Query queryOnCriterion, SearchCriterionDefinition criterion, Collection<Returnable> returnables, AdditionalParameterValueMap additionalParameters)
    {
        if (returnables.contains(_associatedContentReturnable))
        {
            return Optional.of(queryOnCriterion);
        }
        else
        {
            return Optional.empty();
        }
    }
    
    @Override
    public Collection<Returnable> relationsWith()
    {
        return Arrays.asList(_associatedContentReturnable);
    }

    @Override
    protected String associatedContentReturnableRole()
    {
        return CalendarContentReturnable.ROLE;
    }

    @Override
    protected String getCriterionDefinitionPrefix()
    {
        return CRITERION_DEFINITION_PREFIX_ID;
    }

    @Override
    protected Collection<String> getContentTypes(AdditionalParameterValueMap additionalParameterValues)
    {
        Collection<String> contentTypes = additionalParameterValues.getValue(CalendarSearchService.SERVICE_PARAM_CONTENT_TYPES);
        return ObjectUtils.defaultIfNull(contentTypes, Collections.emptyList());
    }

}
