/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.calendar.events;

import java.io.IOException;
import org.ametys.cms.repository.Content;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.calendar.events.AbstractEventGenerator;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.authentication.AuthorizationRequiredException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EventGenerator
extends AbstractEventGenerator {
    protected AmetysObjectResolver _ametysResolver;
    protected RightManager _rightManager;
    protected CurrentUserProvider _currentUserProvider;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._ametysResolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Content content;
        String contentId = this.parameters.getParameter("contentId", "");
        if (StringUtils.isNotEmpty((String)contentId)) {
            contentId = URIUtils.decode((String)contentId);
        }
        if (!(content = (Content)this._ametysResolver.resolveById(contentId)).hasValue("start-date")) {
            throw new IllegalArgumentException("The content must have a metadata named 'start-date' to be imported as an event");
        }
        this._checkUserAccess(content);
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"events");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"contents");
        this.saxContent(this.contentHandler, content, false, null, false);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"contents");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"events");
        this.contentHandler.endDocument();
    }

    private void _checkUserAccess(Content content) {
        UserIdentity user = this._currentUserProvider.getUser();
        boolean readAccess = this._rightManager.hasReadAccess(user, (Object)content);
        if (!readAccess && user == null) {
            throw new AuthorizationRequiredException();
        }
        if (!readAccess) {
            throw new AccessDeniedException("Access to event '" + content.getId() + "' is not allowed for user " + user);
        }
    }
}

