/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.calendar.events;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.type.ElementType;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang.StringUtils;

public final class EventHelper
implements LogEnabled,
Serviceable {
    protected static AmetysObjectResolver _resolver;
    protected static ContentTypeExtensionPoint _contentTypeEP;
    private static Logger _logger;

    public void enableLogging(Logger logger) {
        _logger = logger;
    }

    public void service(ServiceManager manager) throws ServiceException {
        _resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        _contentTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
    }

    public static boolean isBetween(String dateStr, String startStr, String endStr) {
        boolean between = false;
        LocalDate date = LocalDate.parse(dateStr, DateTimeFormatter.ISO_LOCAL_DATE);
        LocalDate start = LocalDate.parse(startStr, DateTimeFormatter.ISO_LOCAL_DATE);
        if (StringUtils.isBlank((String)endStr)) {
            between = date.equals(start);
        } else {
            LocalDate end = LocalDate.parse(endStr, DateTimeFormatter.ISO_LOCAL_DATE);
            between = !(!date.isAfter(start) && !date.equals(start) || !date.isBefore(end) && !date.equals(end));
        }
        return between;
    }

    public static boolean inMonth(String monthStartStr, String eventStartStr, String eventEndStr) {
        boolean overlaps = false;
        Date myDate = DateUtils.parse((String)monthStartStr);
        ZonedDateTime monthStart = myDate.toInstant().atZone(ZoneId.systemDefault());
        ZonedDateTime monthEnd = monthStart.toLocalDate().atStartOfDay(monthStart.getZone()).plusMonths(1L);
        if (StringUtils.isNotBlank((String)eventStartStr) && StringUtils.isNotBlank((String)eventEndStr)) {
            ZonedDateTime eventStart = DateUtils.parse((String)eventStartStr).toInstant().atZone(ZoneId.systemDefault());
            ZonedDateTime eventEnd = DateUtils.parse((String)eventEndStr).toInstant().atZone(ZoneId.systemDefault());
            try {
                overlaps = eventStartStr.equals(eventEndStr) ? EventHelper._contains(monthStart, monthEnd, eventStart) : EventHelper._overlaps(monthStart, monthEnd, eventStart, eventEnd);
            }
            catch (IllegalArgumentException e) {
                overlaps = false;
                _logger.error(String.format("Invalid dates of event: the end date (%s) must be greater or equal to the start date (%s). The event will be ignored in calendar view.", eventEndStr, eventStartStr), (Throwable)e);
            }
        } else if (StringUtils.isNotBlank((String)eventStartStr)) {
            ZonedDateTime eventStart = DateUtils.parse((String)eventStartStr).toInstant().atZone(ZoneId.systemDefault());
            overlaps = EventHelper._contains(monthStart, monthEnd, eventStart);
        } else if (StringUtils.isNotBlank((String)eventEndStr)) {
            ZonedDateTime eventEnd = DateUtils.parse((String)eventEndStr).toInstant().atZone(ZoneId.systemDefault());
            overlaps = EventHelper._contains(monthStart, monthEnd, eventEnd);
        }
        return overlaps;
    }

    private static boolean _contains(ZonedDateTime start, ZonedDateTime end, ZonedDateTime event) {
        ZonedDateTime realEnd;
        ZonedDateTime realStart;
        if (start.isBefore(end)) {
            realStart = start;
            realEnd = end;
        } else {
            realStart = end;
            realEnd = start;
        }
        return (realStart.isBefore(event) || realStart.isEqual(event)) && realEnd.isAfter(event);
    }

    private static boolean _overlaps(ZonedDateTime start1, ZonedDateTime end1, ZonedDateTime start2, ZonedDateTime end2) {
        ZonedDateTime realEnd2;
        ZonedDateTime realStart2;
        ZonedDateTime realEnd1;
        ZonedDateTime realStart1;
        if (start1.isBefore(end1)) {
            realStart1 = start1;
            realEnd1 = end1;
        } else {
            realStart1 = end1;
            realEnd1 = start1;
        }
        if (start2.isBefore(end2)) {
            realStart2 = start2;
            realEnd2 = end2;
        } else {
            realStart2 = end2;
            realEnd2 = start2;
        }
        return (realStart1.isBefore(realEnd2) || realStart1.isEqual(realEnd2)) && realEnd1.isAfter(realStart2);
    }

    public static String nextDay(String dateStr) {
        ZonedDateTime zonedDateTime = DateUtils.parseZonedDateTime((String)dateStr);
        zonedDateTime = zonedDateTime.plusDays(1L);
        return DateUtils.zonedDateTimeToString((ZonedDateTime)zonedDateTime);
    }

    public static String nextDay(String dateStr, String format) {
        String nextDayStr = "";
        ZonedDateTime date = ZonedDateTime.parse(dateStr, DateUtils.getISODateTimeFormatter());
        ZonedDateTime nextDay = date.plusDays(1L);
        nextDayStr = "basicDate".equals(format) ? DateTimeFormatter.BASIC_ISO_DATE.format(nextDay) : DateTimeFormatter.ISO_LOCAL_DATE.format(nextDay);
        return nextDayStr;
    }

    public static boolean isDatetime(String contentId, String attributeName) {
        String[] contentTypeIds;
        Content content = (Content)_resolver.resolveById(contentId);
        for (String contentTypeId : contentTypeIds = content.getTypes()) {
            ContentType contentType = (ContentType)_contentTypeEP.getExtension(contentTypeId);
            if (!contentType.hasModelItem(attributeName)) continue;
            ModelItem definition = contentType.getModelItem(attributeName);
            if (definition instanceof ElementDefinition) {
                ElementType type = ((ElementDefinition)definition).getType();
                return "datetime".equals(type.getId());
            }
            return false;
        }
        return false;
    }
}

