/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.calendar.events;

import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fortuna.ical4j.model.component.VEvent;
import org.ametys.cms.filter.ContentFilter;
import org.ametys.cms.repository.Content;
import org.ametys.cms.tag.Tag;
import org.ametys.cms.tag.TagProviderExtensionPoint;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.calendar.events.AbstractEventGenerator;
import org.ametys.plugins.calendar.events.EventsFilter;
import org.ametys.plugins.calendar.events.EventsFilterHelper;
import org.ametys.plugins.calendar.icsreader.IcsEventHelper;
import org.ametys.plugins.calendar.icsreader.IcsReader;
import org.ametys.plugins.calendar.icsreader.LocalVEvent;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelAwareRepeaterEntry;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.WebConstants;
import org.ametys.web.filter.WebContentFilter;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EventsGenerator
extends AbstractEventGenerator {
    protected AmetysObjectResolver _ametysResolver;
    protected EventsFilterHelper _eventsFilterHelper;
    protected IcsReader _icsReader;
    protected TagProviderExtensionPoint _tagProviderEP;
    private IcsEventHelper _icsEventHelper;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._ametysResolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._eventsFilterHelper = (EventsFilterHelper)((Object)serviceManager.lookup(EventsFilterHelper.ROLE));
        this._icsEventHelper = (IcsEventHelper)serviceManager.lookup(IcsEventHelper.ROLE);
        this._icsReader = (IcsReader)serviceManager.lookup(IcsReader.ROLE);
        this._tagProviderEP = (TagProviderExtensionPoint)this.manager.lookup(TagProviderExtensionPoint.ROLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Map parentContextAttrs = (Map)this.objectModel.get("parent-context");
        if (parentContextAttrs == null) {
            parentContextAttrs = Collections.EMPTY_MAP;
        }
        LocalDate today = LocalDate.now();
        String siteName = this.parameters.getParameter("site", (String)request.getAttribute("site"));
        String lang = this.parameters.getParameter("lang", (String)request.getAttribute("renderingLanguage"));
        if (StringUtils.isEmpty((String)lang)) {
            lang = (String)request.getAttribute("sitemapLanguage");
        }
        int monthsBefore = this.parameters.getParameterAsInteger("months-before", 3);
        int monthsAfter = this.parameters.getParameterAsInteger("months-after", 3);
        String type = this.parameters.getParameter("type", "calendar");
        String view = this.parameters.getParameter("view", "");
        int year = this.parameters.getParameterAsInteger("year", today.getYear());
        int month = this.parameters.getParameterAsInteger("month", today.getMonthValue());
        int day = this.parameters.getParameterAsInteger("day", today.getDayOfMonth());
        String requestedTagsString = this.parameters.getParameter("tags", "all");
        Page currentPage = (Page)request.getAttribute(WebConstants.REQUEST_ATTR_PAGE);
        ZoneItem zoneItem = (ZoneItem)request.getAttribute(WebConstants.REQUEST_ATTR_ZONEITEM);
        String zoneItemId = this.parameters.getParameter("zoneItemId", "");
        if (zoneItem == null && StringUtils.isNotEmpty((String)zoneItemId)) {
            zoneItemId = URIUtils.decode((String)zoneItemId);
            zoneItem = (ZoneItem)this._ametysResolver.resolveById(zoneItemId);
        }
        if (currentPage == null && zoneItem != null) {
            SitemapElement sitemapElement = zoneItem.getZone().getSitemapElement();
            if (sitemapElement instanceof Page) {
                Page page;
                currentPage = page = (Page)sitemapElement;
            } else {
                throw new IllegalStateException("The calendar service cannot be inherited from the sitemap root");
            }
        }
        ZonedDateTime dateTime = ZonedDateTime.of(year, month, day, 0, 0, 0, 0, ZoneId.systemDefault());
        String title = this._eventsFilterHelper.getTitle(zoneItem);
        String rangeType = this.parameters.getParameter("rangeType", this._eventsFilterHelper.getDefaultRangeType(zoneItem));
        boolean maskOrphan = this._eventsFilterHelper.getMaskOrphan(zoneItem);
        boolean pdfDownload = this._eventsFilterHelper.getPdfDownload(zoneItem);
        boolean icalDownload = this._eventsFilterHelper.getIcalDownload(zoneItem);
        String link = this._eventsFilterHelper.getLink(zoneItem);
        String linkTitle = this._eventsFilterHelper.getLinkTitle(zoneItem);
        boolean doRetrieveView = !StringUtils.equalsIgnoreCase((String)"false", (String)this.parameters.getParameter("do-retrieve-view", "true"));
        List<Map<String, Object>> searchContexts = this._eventsFilterHelper.getSearchContext(zoneItem, (List)parentContextAttrs.get("search"));
        Set<String> tags = this._eventsFilterHelper.getTags(zoneItem, searchContexts);
        Set<Tag> categories = this._eventsFilterHelper.getTagCategories(zoneItem, searchContexts, siteName);
        Set<Tag> icsTags = this._getIcsTags(zoneItem, siteName);
        String pagePath = currentPage != null ? currentPage.getPathInSitemap() : "";
        Set<String> filteredCategories = this._eventsFilterHelper.getFilteredCategories(null, requestedTagsString.split(","), zoneItem, siteName);
        EventsFilterHelper.DateTimeRange dateRange = this._eventsFilterHelper.getDateRange(type, year, month, day, monthsBefore, monthsAfter, rangeType);
        EventsFilter eventsFilter = this._eventsFilterHelper.generateEventFilter(dateRange, zoneItem, view, type, filteredCategories, searchContexts);
        AmetysObjectIterable eventContents = eventsFilter.getMatchingContents(siteName, lang, currentPage);
        List<IcsReader.IcsEvents> parsedICS = icalDownload && zoneItem != null && type.equals("full") ? this._icsEventHelper.getICSEvents(zoneItem, siteName, dateRange, Long.MAX_VALUE, Long.MAX_VALUE) : this._icsEventHelper.getICSEvents(zoneItem, siteName, dateRange);
        String currentSiteName = (String)request.getAttribute("site");
        String currentSkinName = (String)request.getAttribute("skin");
        String currentTemplateName = (String)request.getAttribute("template");
        String currentLanguage = (String)request.getAttribute("renderingLanguage");
        request.setAttribute("finalsite", (Object)currentSiteName);
        request.setAttribute("finalskin", (Object)currentSkinName);
        try {
            this._sax(today, monthsBefore, monthsAfter, year, month, day, filteredCategories, currentPage, zoneItem, dateTime, title, rangeType, maskOrphan, pdfDownload, icalDownload, link, linkTitle, doRetrieveView, tags, categories, icsTags, pagePath, eventsFilter, dateRange, (AmetysObjectIterable<Content>)eventContents, parsedICS);
        }
        finally {
            request.removeAttribute("finalsite");
            request.removeAttribute("finalskin");
            request.setAttribute("site", (Object)currentSiteName);
            request.setAttribute("siteName", (Object)currentSiteName);
            request.setAttribute("skin", (Object)currentSkinName);
            request.setAttribute("template", (Object)currentTemplateName);
            request.setAttribute("renderingLanguage", (Object)currentLanguage);
        }
    }

    private Set<Tag> _getIcsTags(ZoneItem zoneItem, String currentSiteName) {
        ModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
        LinkedHashSet<Tag> categories = new LinkedHashSet<Tag>();
        if (serviceParameters.hasValue("ics")) {
            ModifiableModelAwareRepeater icsRepeater = (ModifiableModelAwareRepeater)serviceParameters.getValue("ics");
            for (ModifiableModelAwareRepeaterEntry repeaterEntry : icsRepeater.getEntries()) {
                String categoryName = (String)repeaterEntry.getValue("tag");
                HashMap<String, String> contextualParameters = new HashMap<String, String>();
                contextualParameters.put("siteName", currentSiteName);
                Tag category = this._tagProviderEP.getTag(categoryName, contextualParameters);
                if (category == null) continue;
                categories.add(category);
            }
        }
        return categories;
    }

    private void _sax(LocalDate today, int monthsBefore, int monthsAfter, int year, int month, int day, Set<String> filteredCategoryTags, Page page, ZoneItem zoneItem, ZonedDateTime date, String title, String rangeType, boolean maskOrphan, boolean pdfDownload, boolean icalDownload, String link, String linkTitle, boolean doRetrieveView, Set<String> tags, Set<Tag> categories, Set<Tag> icsTags, String pagePath, EventsFilter eventsFilter, EventsFilterHelper.DateTimeRange dateRange, AmetysObjectIterable<Content> eventContents, List<IcsReader.IcsEvents> icsEvents) throws SAXException, IOException {
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("page-path", pagePath);
        atts.addCDATAAttribute("today", DateTimeFormatter.ISO_LOCAL_DATE.format(today));
        if (dateRange != null) {
            if (dateRange.fromDate() != null) {
                atts.addCDATAAttribute("start", DateTimeFormatter.ISO_LOCAL_DATE.format(dateRange.fromDate()));
            }
            if (dateRange.untilDate() != null) {
                atts.addCDATAAttribute("end", DateTimeFormatter.ISO_LOCAL_DATE.format(dateRange.untilDate()));
            }
        }
        atts.addCDATAAttribute("year", Integer.toString(year));
        atts.addCDATAAttribute("month", String.format("%02d", month));
        atts.addCDATAAttribute("day", String.format("%02d", day));
        atts.addCDATAAttribute("months-before", Integer.toString(monthsBefore));
        atts.addCDATAAttribute("months-after", Integer.toString(monthsAfter));
        atts.addCDATAAttribute("title", title);
        atts.addCDATAAttribute("mask-orphan", Boolean.toString(maskOrphan));
        atts.addCDATAAttribute("pdf-download", Boolean.toString(pdfDownload));
        atts.addCDATAAttribute("ical-download", Boolean.toString(icalDownload));
        atts.addCDATAAttribute("link", link);
        atts.addCDATAAttribute("link-title", linkTitle);
        if (zoneItem != null) {
            atts.addCDATAAttribute("zoneItemId", zoneItem.getId());
        }
        if (StringUtils.isNotEmpty((String)rangeType)) {
            atts.addCDATAAttribute("range", rangeType);
        }
        if (!filteredCategoryTags.isEmpty()) {
            atts.addCDATAAttribute("requested-tags", String.join((CharSequence)",", filteredCategoryTags));
        }
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"events", (Attributes)atts);
        this._saxRssUrl(zoneItem);
        this._saxMonths(dateRange);
        this._saxDays(date, rangeType);
        this._saxDaysNew(dateRange, rangeType);
        this._saxTags((Collection<String>)tags);
        this._saxCategories(categories, icsTags);
        Pair<List<LocalVEvent>, String> parsedICSEvents = this._icsEventHelper.toLocalIcsEvent(icsEvents, dateRange);
        List localIcsEvents = (List)parsedICSEvents.getLeft();
        String fullICSDistantEvents = (String)parsedICSEvents.getRight();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"contents");
        this.saxMatchingContents(this.contentHandler, (WebContentFilter)eventsFilter, eventContents, page, doRetrieveView);
        this.saxIcsEvents(this.contentHandler, localIcsEvents);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"contents");
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"rawICS", (String)fullICSDistantEvents);
        this._icsEventHelper.saxICSErrors(icsEvents, this.contentHandler);
        if (icalDownload) {
            String timezones = this._icsEventHelper.toVTimeZone(icsEvents, dateRange, List.of());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"timezones", (String)timezones);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"events");
        this.contentHandler.endDocument();
    }

    private void _saxRssUrl(ZoneItem zoneItem) throws SAXException {
        ModifiableModelAwareRepeater searchRepeater;
        ModelAwareDataHolder serviceParameters;
        if (zoneItem != null && (serviceParameters = zoneItem.getServiceParameters()).hasValue("rss") && ((Boolean)serviceParameters.getValue("rss")).booleanValue() && serviceParameters.hasValue("search") && (searchRepeater = (ModifiableModelAwareRepeater)serviceParameters.getValue("search")).getSize() > 0) {
            String[] zoneItemId = zoneItem.getId().split("://");
            String url = "_plugins/calendar/" + zoneItemId[1] + "/rss.xml";
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"rssUrl", (String)url);
        }
    }

    public void saxMatchingContents(ContentHandler handler, WebContentFilter filter, AmetysObjectIterable<Content> contents, Page currentPage, boolean saxContentItSelf) throws SAXException, IOException {
        boolean checkUserAccess = filter.getAccessLimitation() == WebContentFilter.AccessLimitation.USER_ACCESS;
        for (Content content : contents) {
            if (!this._filterHelper.isContentValid(content, currentPage, (ContentFilter)filter)) continue;
            this.saxContent(handler, content, saxContentItSelf, filter, checkUserAccess);
        }
    }

    public void saxIcsEvents(ContentHandler handler, List<LocalVEvent> icsEvents) throws SAXException {
        for (LocalVEvent icsEvent : icsEvents) {
            this.saxIcsEvent(handler, icsEvent);
        }
    }

    public void saxIcsEvent(ContentHandler handler, LocalVEvent icsEvent) throws SAXException {
        VEvent event = icsEvent.getEvent();
        AttributesImpl attrs = new AttributesImpl();
        String start = DateUtils.dateToString((Date)icsEvent.getStart());
        String end = DateUtils.dateToString((Date)icsEvent.getEnd());
        ArrayList<String> params = new ArrayList<String>();
        String title = event.getProperty("SUMMARY") != null ? event.getProperty("SUMMARY").getValue() : "";
        String id = event.getProperty("UID") != null ? event.getProperty("UID").getValue() : UUID.randomUUID().toString();
        String eventAbstract = event.getProperty("DESCRIPTION") != null ? event.getProperty("DESCRIPTION").getValue() : "";
        params.add(title);
        if (start != null) {
            String startAttr = DateUtils.asZonedDateTime((Date)icsEvent.getStart(), null).format(DateTimeFormatter.ISO_LOCAL_DATE);
            params.add(start);
            attrs.addCDATAAttribute("start", startAttr);
        }
        if (end != null) {
            String endAttr = DateUtils.asZonedDateTime((Date)icsEvent.getEnd(), null).format(DateTimeFormatter.ISO_LOCAL_DATE);
            params.add(end);
            attrs.addCDATAAttribute("end", endAttr);
        }
        XMLUtils.startElement((ContentHandler)handler, (String)"event", (Attributes)attrs);
        String key = end == null ? "CALENDAR_SERVICE_AGENDA_EVENT_TITLE_SINGLE_DAY" : "CALENDAR_SERVICE_AGENDA_FROM_TO";
        I18nizableText description = new I18nizableText(null, key, params);
        description.toSAX(handler, "description");
        attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", "ics://" + id);
        attrs.addCDATAAttribute("title", title);
        Date dtStamp = event.getDateStamp() != null ? event.getDateStamp().getDate() : new Date();
        Date createdAtDate = event.getCreated() != null ? event.getCreated().getDate() : dtStamp;
        Date lastModifiedDate = event.getLastModified() != null ? event.getLastModified().getDate() : dtStamp;
        String createdAt = DateUtils.asZonedDateTime((Date)createdAtDate, null).format(DateTimeFormatter.ISO_INSTANT);
        attrs.addCDATAAttribute("createdAt", createdAt);
        String lastModified = DateUtils.asZonedDateTime((Date)lastModifiedDate, null).format(DateTimeFormatter.ISO_INSTANT);
        attrs.addCDATAAttribute("lastModifiedAt", lastModified);
        XMLUtils.startElement((ContentHandler)handler, (String)"content", (Attributes)attrs);
        XMLUtils.startElement((ContentHandler)handler, (String)"metadata");
        attrs = new AttributesImpl();
        attrs.addCDATAAttribute("typeId", "string");
        attrs.addCDATAAttribute("multiple", "false");
        XMLUtils.createElement((ContentHandler)handler, (String)"title", (Attributes)attrs, (String)title);
        XMLUtils.createElement((ContentHandler)handler, (String)"abstract", (Attributes)attrs, (String)eventAbstract);
        attrs = new AttributesImpl();
        attrs.addCDATAAttribute("typeId", "datetime");
        attrs.addCDATAAttribute("multiple", "false");
        XMLUtils.createElement((ContentHandler)handler, (String)"start-date", (Attributes)attrs, (String)start);
        XMLUtils.createElement((ContentHandler)handler, (String)"end-date", (Attributes)attrs, (String)end);
        XMLUtils.endElement((ContentHandler)handler, (String)"metadata");
        Tag tag = icsEvent.getTag();
        if (tag != null) {
            XMLUtils.startElement((ContentHandler)handler, (String)"tags");
            attrs = new AttributesImpl();
            attrs.addCDATAAttribute("parent", tag.getParentName());
            XMLUtils.startElement((ContentHandler)handler, (String)tag.getName(), (Attributes)attrs);
            tag.getTitle().toSAX(handler);
            XMLUtils.endElement((ContentHandler)handler, (String)tag.getName());
            XMLUtils.endElement((ContentHandler)handler, (String)"tags");
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"content");
        XMLUtils.endElement((ContentHandler)handler, (String)"event");
    }

    protected void _saxMonths(EventsFilterHelper.DateTimeRange dateRange) throws SAXException {
        if (dateRange != null && dateRange.fromDate() != null && dateRange.untilDate() != null) {
            AttributesImpl atts = new AttributesImpl();
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"months");
            ZonedDateTime date = dateRange.fromDate();
            ZonedDateTime end = dateRange.untilDate();
            while (date.isBefore(end)) {
                int year = date.getYear();
                int month = date.getMonthValue();
                String monthStr = String.format("%d-%02d", year, month);
                String dateStr = DateUtils.getISODateTimeFormatter().format(date);
                atts.clear();
                atts.addCDATAAttribute("str", monthStr);
                atts.addCDATAAttribute("raw", dateStr);
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"month", (Attributes)atts);
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"month");
                date = date.plusMonths(1L);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"months");
        }
    }

    protected void _saxDaysNew(EventsFilterHelper.DateTimeRange dateRange, String rangeType) throws SAXException {
        if (dateRange != null) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"calendar-months");
            ZonedDateTime date = dateRange.fromDate();
            ZonedDateTime end = dateRange.untilDate();
            while (date.isBefore(end)) {
                int year = date.getYear();
                int month = date.getMonthValue();
                String monthStr = String.format("%d-%02d", year, month);
                String dateStr = DateUtils.getISODateTimeFormatter().format(date);
                AttributesImpl attrs = new AttributesImpl();
                attrs.addCDATAAttribute("str", monthStr);
                attrs.addCDATAAttribute("raw", dateStr);
                attrs.addCDATAAttribute("year", Integer.toString(year));
                attrs.addCDATAAttribute("month", Integer.toString(month));
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"month", (Attributes)attrs);
                this._saxDays(date, "month");
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"month");
                date = date.plusMonths(1L);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"calendar-months");
        }
    }

    protected void _saxDays(ZonedDateTime date, String type) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        int rangeStyle = 6;
        ZonedDateTime previousDay = null;
        ZonedDateTime nextDay = null;
        if ("week".equals(type)) {
            rangeStyle = 2;
            previousDay = date.with(ChronoField.DAY_OF_WEEK, 1L);
            nextDay = previousDay.plusWeeks(1L);
            previousDay = previousDay.minusWeeks(1L);
        } else {
            rangeStyle = 6;
            previousDay = date.with(ChronoField.DAY_OF_MONTH, 1L);
            nextDay = previousDay.plusMonths(1L);
            previousDay = previousDay.minusMonths(1L);
        }
        this.addNavAttributes(attrs, date, previousDay, nextDay);
        Iterator days = org.apache.commons.lang.time.DateUtils.iterator((Date)DateUtils.asDate((ZonedDateTime)date), (int)rangeStyle);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"calendar", (Attributes)attrs);
        ZonedDateTime previousWeekDay = date.minusWeeks(1L);
        ZonedDateTime nextWeekDay = date.plusWeeks(1L);
        AttributesImpl weekAttrs = new AttributesImpl();
        this.addNavAttributes(weekAttrs, date, previousWeekDay, nextWeekDay);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"week", (Attributes)weekAttrs);
        while (days.hasNext()) {
            Calendar dayCal = (Calendar)days.next();
            ZonedDateTime day = dayCal.toInstant().atZone(dayCal.getTimeZone().toZoneId());
            String rawDateStr = DateUtils.getISODateTimeFormatter().format(day);
            String dateStr = DateTimeFormatter.ISO_LOCAL_DATE.format(day);
            String yearStr = Integer.toString(dayCal.get(1));
            String monthStr = Integer.toString(dayCal.get(2) + 1);
            String dayStr = Integer.toString(dayCal.get(5));
            AttributesImpl dayAttrs = new AttributesImpl();
            dayAttrs.addCDATAAttribute("raw", rawDateStr);
            dayAttrs.addCDATAAttribute("date", dateStr);
            dayAttrs.addCDATAAttribute("year", yearStr);
            dayAttrs.addCDATAAttribute("month", monthStr);
            dayAttrs.addCDATAAttribute("day", dayStr);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"day", (Attributes)dayAttrs);
            if (dayCal.get(7) != this._eventsFilterHelper.getLastDayOfWeek(dayCal) || !days.hasNext()) continue;
            previousWeekDay = day.minusDays(6L);
            nextWeekDay = day.plusDays(8L);
            weekAttrs.clear();
            this.addNavAttributes(weekAttrs, day, previousWeekDay, nextWeekDay);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"week");
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"week", (Attributes)weekAttrs);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"week");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"calendar");
    }

    protected void addNavAttributes(AttributesImpl attrs, ZonedDateTime current, ZonedDateTime previousDay, ZonedDateTime nextDay) {
        attrs.addCDATAAttribute("current", DateUtils.getISODateTimeFormatter().format(current));
        attrs.addCDATAAttribute("previous", DateUtils.getISODateTimeFormatter().format(previousDay));
        attrs.addCDATAAttribute("previousYear", Integer.toString(previousDay.getYear()));
        attrs.addCDATAAttribute("previousMonth", Integer.toString(previousDay.getMonthValue()));
        attrs.addCDATAAttribute("previousDay", Integer.toString(previousDay.getDayOfMonth()));
        attrs.addCDATAAttribute("next", DateUtils.getISODateTimeFormatter().format(nextDay));
        attrs.addCDATAAttribute("nextYear", Integer.toString(nextDay.getYear()));
        attrs.addCDATAAttribute("nextMonth", Integer.toString(nextDay.getMonthValue()));
        attrs.addCDATAAttribute("nextDay", Integer.toString(nextDay.getDayOfMonth()));
    }

    protected void _saxTags(Collection<String> tags) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"tags");
        for (String tag : tags) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("name", tag);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"tag", (Attributes)attrs);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"tags");
    }

    protected void _saxCategories(Collection<Tag> categories, Collection<Tag> icsTags) throws SAXException {
        Tag parent;
        HashMap icsTagsToAdd = new HashMap();
        for (Tag tag : icsTags) {
            parent = tag.getParent();
            if (icsTagsToAdd.containsKey(parent)) {
                ((Set)icsTagsToAdd.get(parent)).add(tag);
                continue;
            }
            if (categories != null && categories.contains(tag.getParent())) continue;
            icsTagsToAdd.put(parent, new LinkedHashSet());
            ((Set)icsTagsToAdd.get(parent)).add(tag);
        }
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"tag-categories");
        if (categories != null) {
            for (Tag tag : categories) {
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"category");
                tag.getTitle().toSAX(this.contentHandler, "title");
                this._saxTags(this._eventsFilterHelper.getAllTags(tag));
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"category");
            }
        }
        for (Map.Entry entry : icsTagsToAdd.entrySet()) {
            parent = (Tag)entry.getKey();
            Set tags = (Set)entry.getValue();
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"category");
            if (parent != null) {
                parent.getTitle().toSAX(this.contentHandler, "title");
            } else {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title");
            }
            this._saxTags(tags);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"category");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"tag-categories");
    }

    protected void _saxTags(Set<Tag> tags) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"tags");
        for (Tag tag : tags) {
            AttributesImpl tagAttrs = new AttributesImpl();
            tagAttrs.addCDATAAttribute("name", tag.getName());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"tag", (Attributes)tagAttrs);
            tag.getTitle().toSAX(this.contentHandler);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"tag");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"tags");
    }
}

