<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:math="http://exslt.org/math"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                exclude-result-prefixes="resolver math">

    <xsl:import href="plugin:cms://stylesheets/helper/html-hierarchy.xsl"/>

	<xsl:variable name="view">abstract</xsl:variable>
	
	<xsl:template match="/">
        <xsl:variable name="date" select="concat(events/@year, '-', events/@month, '-', events/@day)"/>
		<html>
			<head>
                <title>
                    <i18n:translate>
                        <i18n:text i18n:key="CALENDAR_SERVICE_CALENDAR_DAY_EVENTS_TITLE"/>
                        <i18n:param>
                            <i18n:date src-pattern="yyyy-MM-dd" pattern="d MMMM yyyy" value="{$date}"/>
                        </i18n:param>
                    </i18n:translate>
                </title>
				<link href="{ametys:pluginResourceURL('web', 'css/service/filtered-contents.css')}" type="text/css" rel="stylesheet" />
			</head>
			<body id="default">
				<xsl:if test="events/contents/event/view/content">
					<div class="content-list-wrapper {$view} events-list">
						<h1>
                            <i18n:translate>
                                <i18n:text i18n:key="CALENDAR_SERVICE_CALENDAR_DAY_EVENTS_TITLE"/>
                                <i18n:param>
                                    <i18n:date src-pattern="yyyy-MM-dd" pattern="d MMMM yyyy" value="{$date}"/>
                                </i18n:param>
                            </i18n:translate>
                        </h1>
                        <xsl:apply-templates select="events/contents/event/view/content"/>
					</div>
				</xsl:if>
			</body>
		</html>
	</xsl:template>
    
    <xsl:template match="content">
        <div class="article">
            <xsl:apply-templates select="html/body/node()" mode="move-hierarchy">
                <xsl:with-param name="level" select="2"/>
            </xsl:apply-templates>
        </div>
    </xsl:template>
	
</xsl:stylesheet>
