/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.calendar.icsreader.ical4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;

import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.model.parameter.Abbrev;
import net.fortuna.ical4j.model.parameter.AltRep;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.CuType;
import net.fortuna.ical4j.model.parameter.DelegatedFrom;
import net.fortuna.ical4j.model.parameter.DelegatedTo;
import net.fortuna.ical4j.model.parameter.Dir;
import net.fortuna.ical4j.model.parameter.Display;
import net.fortuna.ical4j.model.parameter.Encoding;
import net.fortuna.ical4j.model.parameter.FbType;
import net.fortuna.ical4j.model.parameter.Feature;
import net.fortuna.ical4j.model.parameter.FmtType;
import net.fortuna.ical4j.model.parameter.Label;
import net.fortuna.ical4j.model.parameter.Language;
import net.fortuna.ical4j.model.parameter.Member;
import net.fortuna.ical4j.model.parameter.PartStat;
import net.fortuna.ical4j.model.parameter.Range;
import net.fortuna.ical4j.model.parameter.RelType;
import net.fortuna.ical4j.model.parameter.Related;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.parameter.Rsvp;
import net.fortuna.ical4j.model.parameter.ScheduleAgent;
import net.fortuna.ical4j.model.parameter.ScheduleStatus;
import net.fortuna.ical4j.model.parameter.SentBy;
import net.fortuna.ical4j.model.parameter.Type;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.parameter.Vvenue;

//FIXME this class is a copy of the DefaultParameterFactorySupplier from ical4j, with the new Email parameter in the same package, without the javax.mail dependency
//to be removed as soon as ical4j 4.0 is released
//ical4j is licensed under the BSD license
@SuppressWarnings("all")
public class AmetysParameterFactorySupplier implements Supplier<List<ParameterFactory<?>>> 
{
    @SuppressWarnings("unchecked")
    @Override
    public List<ParameterFactory<?>> get() 
    {
        List<ParameterFactory<?>> rfc5545 = Arrays.<ParameterFactory<?>>asList(new Abbrev.Factory(), 
                                                       new AltRep.Factory(), 
                                                       new Cn.Factory(), 
                                                       new CuType.Factory(),
                                                       new DelegatedFrom.Factory(), 
                                                       new DelegatedTo.Factory(), 
                                                       new Dir.Factory(), 
                                                       new Encoding.Factory(), 
                                                       new FmtType.Factory(),
                                                       new FbType.Factory(), 
                                                       new Language.Factory(), 
                                                       new Member.Factory(), 
                                                       new PartStat.Factory(),
                                                       new Range.Factory(), 
                                                       new Related.Factory(), 
                                                       new RelType.Factory(), 
                                                       new Role.Factory(),
                                                       new Rsvp.Factory(), 
                                                       new ScheduleAgent.Factory(), 
                                                       new ScheduleStatus.Factory(),
                                                       new SentBy.Factory(), 
                                                       new Type.Factory(), 
                                                       new TzId.Factory(),
                                                       new Value.Factory(), 
                                                       new Vvenue.Factory());


        List<ParameterFactory<?>> rfc7986 = Arrays.<ParameterFactory<?>>asList(new Display.Factory(), 
                                                                               new Email.Factory(), 
                                                                               new Feature.Factory(),
                                                                               new Label.Factory());

        List<ParameterFactory<?>> factories = new ArrayList<>(rfc5545);
        factories.addAll(rfc7986);

        return factories;
    }
}
