/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.calendar.enumerators;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeEnumerator;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;

public class CalendarContentTypesEnumerator
extends ContentTypeEnumerator {
    protected Map<String, Set<String>> _mandatoryAttributes;

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        Configuration mandatoryAttributesConf = configuration.getChild("enumeration").getChild("custom-enumerator").getChild("mandatory-metadata", false);
        if (mandatoryAttributesConf == null) {
            this._mandatoryAttributes = null;
        } else {
            Configuration[] metadataRefConfs;
            this._mandatoryAttributes = new HashMap<String, Set<String>>();
            for (Configuration metadataRefConf : metadataRefConfs = mandatoryAttributesConf.getChildren("metadata-ref")) {
                String name = metadataRefConf.getValue(null);
                String[] types = StringUtils.split((String)metadataRefConf.getAttribute("type", "string"), (char)',');
                HashSet<String> attributeTypes = new HashSet<String>(types.length);
                for (String type : types) {
                    attributeTypes.add(type.trim().toUpperCase());
                }
                this._mandatoryAttributes.put(name, attributeTypes);
            }
            this._mandatoryAttributes.remove(null);
        }
    }

    public Map<String, I18nizableText> getEntries() throws Exception {
        HashMap<String, I18nizableText> entries = new HashMap<String, I18nizableText>();
        Set contentTypes = this.getMatchingContentTypes();
        for (ContentType contentType : contentTypes) {
            Collection rejectedAttributes = CollectionUtils.selectRejected(this._mandatoryAttributes.keySet(), (Predicate)new MandatoryAttributePredicate(contentType));
            if (!rejectedAttributes.isEmpty()) continue;
            entries.put(contentType.getId(), contentType.getLabel());
        }
        return entries;
    }

    public class MandatoryAttributePredicate
    implements Predicate {
        private ContentType _contentType;

        protected MandatoryAttributePredicate(ContentType contentType) {
            this._contentType = contentType;
        }

        public boolean evaluate(Object object) {
            String attributeName = (String)object;
            return this._isDefined(attributeName) && this._isTypeCorrect(attributeName);
        }

        private boolean _isDefined(String attributeName) {
            return this._contentType.hasModelItem(attributeName);
        }

        private boolean _isTypeCorrect(String attributeName) {
            ModelItem modelItem = this._contentType.getModelItem(attributeName);
            if (modelItem instanceof ElementDefinition) {
                String modelItemType = ((ElementDefinition)modelItem).getType().getId().toUpperCase();
                return CalendarContentTypesEnumerator.this._mandatoryAttributes.get(attributeName).contains(modelItemType);
            }
            return false;
        }
    }
}

