/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.calendar.icsreader;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.model.property.Created;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Url;
import org.ametys.cms.tag.Tag;
import org.ametys.cms.tag.TagProviderExtensionPoint;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.calendar.events.EventsFilterHelper;
import org.ametys.plugins.calendar.icsreader.IcsReader;
import org.ametys.plugins.calendar.icsreader.LocalVEvent;
import org.ametys.plugins.calendar.search.CalendarSearchService;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelAwareRepeaterEntry;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class IcsEventHelper
implements Component,
Serviceable {
    public static final String ROLE = IcsEventHelper.class.getName();
    protected IcsReader _icsReader;
    protected TagProviderExtensionPoint _tagProviderEP;

    public void service(ServiceManager smanager) throws ServiceException {
        this._icsReader = (IcsReader)smanager.lookup(IcsReader.ROLE);
        this._tagProviderEP = (TagProviderExtensionPoint)smanager.lookup(TagProviderExtensionPoint.ROLE);
    }

    public List<IcsReader.IcsEvents> getICSEvents(ZoneItem zoneItem, String siteName, EventsFilterHelper.DateTimeRange dateRange) {
        List<IcsReader.IcsEvents> icsEvents = new ArrayList<IcsReader.IcsEvents>();
        if (zoneItem != null && zoneItem.getServiceParameters().hasValue("ics")) {
            Long nbIcsEvent = (Long)zoneItem.getServiceParameters().getValue("nbEvents");
            Long maxIcsSize = (Long)zoneItem.getServiceParameters().getValue("maxSize");
            icsEvents = this.getICSEvents(zoneItem, siteName, dateRange, nbIcsEvent, maxIcsSize);
        }
        return icsEvents;
    }

    public List<IcsReader.IcsEvents> getICSEvents(ZoneItem zoneItem, String siteName, EventsFilterHelper.DateTimeRange dateRange, Long nbEvents, Long maxFileSize) {
        ArrayList<IcsReader.IcsEvents> icsEvents = new ArrayList<IcsReader.IcsEvents>();
        if (zoneItem.getServiceParameters().hasValue("ics")) {
            ModifiableModelAwareRepeater icsRepeater = (ModifiableModelAwareRepeater)zoneItem.getServiceParameters().getValue("ics");
            for (ModifiableModelAwareRepeaterEntry repeaterEntry : icsRepeater.getEntries()) {
                Tag tag;
                String url = (String)repeaterEntry.getValue("url");
                IcsReader.IcsEvents eventList = this._icsReader.getEventList(url, dateRange, nbEvents, maxFileSize);
                String tagName = (String)repeaterEntry.getValue("tag");
                if (StringUtils.isNotEmpty((CharSequence)tagName) && (tag = this._tagProviderEP.getTag(tagName, Map.of("siteName", siteName))) != null) {
                    eventList.setTag(tag);
                }
                icsEvents.add(eventList);
            }
        }
        return icsEvents;
    }

    public Set<Tag> getIcsTags(ZoneItem zoneItem, String siteName) {
        LinkedHashSet<Tag> tags = new LinkedHashSet<Tag>();
        if (zoneItem != null && zoneItem.getServiceParameters().hasValue("ics")) {
            ModifiableModelAwareRepeater icsRepeater = (ModifiableModelAwareRepeater)zoneItem.getServiceParameters().getValue("ics");
            for (ModifiableModelAwareRepeaterEntry repeaterEntry : icsRepeater.getEntries()) {
                String tagName = (String)repeaterEntry.getValue("tag");
                Tag tag = this._tagProviderEP.getTag(tagName, Map.of("siteName", siteName));
                if (tag == null) continue;
                tags.add(tag);
            }
        }
        return tags;
    }

    public Pair<List<LocalVEvent>, String> toLocalIcsEvent(List<IcsReader.IcsEvents> icsEventsList, EventsFilterHelper.DateTimeRange dateRange) {
        return this.toLocalIcsEvent(icsEventsList, dateRange, List.of());
    }

    public Pair<List<LocalVEvent>, String> toLocalIcsEvent(List<IcsReader.IcsEvents> icsEventsList, EventsFilterHelper.DateTimeRange dateRange, List<String> filteredTags) {
        ArrayList<LocalVEvent> localICSEvents = new ArrayList<LocalVEvent>();
        Object fullICSDistantEvents = "";
        for (IcsReader.IcsEvents icsEvents : icsEventsList) {
            if (!icsEvents.hasEvents()) continue;
            Tag tag = icsEvents.getTag();
            if (!filteredTags.isEmpty() && (tag == null || !filteredTags.contains(tag.getName()))) continue;
            for (VEvent calendarComponent : icsEvents.getEvents()) {
                List<LocalVEvent> localCalendarComponents = this._icsReader.getEventDates(calendarComponent, dateRange, tag);
                localICSEvents.addAll(localCalendarComponents);
                if (dateRange != null) continue;
                fullICSDistantEvents = (String)fullICSDistantEvents + calendarComponent.toString() + "\n";
            }
        }
        return new ImmutablePair(localICSEvents, fullICSDistantEvents);
    }

    public String toVTimeZone(List<IcsReader.IcsEvents> icsEventsList, EventsFilterHelper.DateTimeRange dateRange, List<String> filteredTags) {
        HashSet<String> timeZoneIds = new HashSet<String>();
        Object timeZonesAsString = "";
        for (IcsReader.IcsEvents icsEvents : icsEventsList) {
            if (!icsEvents.hasEvents()) continue;
            Tag tag = icsEvents.getTag();
            if (!filteredTags.isEmpty() && (tag == null || !filteredTags.contains(tag.getName()))) continue;
            for (VEvent calendarComponent : icsEvents.getEvents()) {
                DtEnd dateTimeEnd;
                TzId endDateTZ;
                TzId startDateTZ;
                DtStart dateTimeStart = calendarComponent.getDateTimeStart();
                TzId tzId = startDateTZ = dateTimeStart != null ? (TzId)dateTimeStart.getParameter("TZID").orElse(null) : null;
                if (startDateTZ != null && !timeZoneIds.contains(startDateTZ.getValue())) {
                    timeZoneIds.add(startDateTZ.getValue());
                    timeZonesAsString = (String)timeZonesAsString + startDateTZ.getValue() + "\n";
                }
                if ((endDateTZ = (dateTimeEnd = calendarComponent.getDateTimeEnd()) != null ? (TzId)dateTimeEnd.getParameter("TZID").orElse(null) : null) == null || timeZoneIds.contains(endDateTZ.getValue())) continue;
                timeZoneIds.add(endDateTZ.getValue());
                timeZonesAsString = (String)timeZonesAsString + endDateTZ.getValue() + "\n";
            }
        }
        return timeZonesAsString;
    }

    public void saxIcsEventHits(ContentHandler handler, List<LocalVEvent> icsEvents, int startNumber) throws SAXException {
        int hitIndex = startNumber;
        for (LocalVEvent icsEvent : icsEvents) {
            this.saxIcsEventHit(handler, icsEvent, hitIndex++);
        }
    }

    public void saxIcsEventHit(ContentHandler handler, LocalVEvent icsEvent, int number) throws SAXException {
        VEvent event = icsEvent.getEvent();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("number", Integer.toString(number));
        attrs.addCDATAAttribute("icsEvent", "true");
        XMLUtils.startElement((ContentHandler)handler, (String)"hit", (Attributes)attrs);
        String id = event.getProperty("UID").map(Content::getValue).orElse(UUID.randomUUID().toString());
        XMLUtils.createElement((ContentHandler)handler, (String)"id", (String)id);
        this.saxIcsEvent(handler, icsEvent);
        XMLUtils.endElement((ContentHandler)handler, (String)"hit");
    }

    public void saxIcsEvent(ContentHandler handler, LocalVEvent icsEvent) throws SAXException {
        XMLUtils.startElement((ContentHandler)handler, (String)"event");
        VEvent event = icsEvent.getEvent();
        String title = event.getProperty("SUMMARY").map(Content::getValue).orElse("");
        XMLUtils.createElement((ContentHandler)handler, (String)"title", (String)title);
        String description = event.getProperty("DESCRIPTION").map(Content::getValue).orElse("");
        XMLUtils.createElement((ContentHandler)handler, (String)"description", (String)description);
        DtStamp dateTimeStamp = event.getDateTimeStamp();
        Instant dtStamp = dateTimeStamp != null ? (Instant)dateTimeStamp.getDate() : Instant.now();
        Created created = event.getCreated();
        Instant creationDate = created != null ? (Instant)created.getDate() : dtStamp;
        LastModified lastModified = event.getLastModified();
        Instant lastModifiedDate = lastModified != null ? (Instant)lastModified.getDate() : dtStamp;
        this._saxInstant(handler, "creationDate", creationDate);
        this._saxInstant(handler, "lastModifiedDate", lastModifiedDate);
        this._saxZonedDateTime(handler, "startDate", icsEvent.getStart());
        this._saxZonedDateTime(handler, "endDate", icsEvent.getEnd());
        this._saxAllDay(handler, icsEvent);
        CalendarSearchService.saxTag(handler, icsEvent.getTag());
        Url url = event.getUrl();
        if (url != null) {
            XMLUtils.createElement((ContentHandler)handler, (String)"url", (String)url.getValue());
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"event");
    }

    protected void _saxAllDay(ContentHandler handler, LocalVEvent icsEvent) throws SAXException {
        VEvent event = icsEvent.getEvent();
        DtStart startDate = event.getDateTimeStart();
        DtEnd endDate = event.getDateTimeEnd();
        boolean allDayEvent = startDate != null && "DATE".equals(startDate.getParameter("VALUE").map(Content::getValue).orElse(null)) && (endDate == null || "DATE".equals(endDate.getParameter("VALUE").map(Content::getValue).orElse(null)));
        XMLUtils.createElement((ContentHandler)handler, (String)"allDay", (String)String.valueOf(allDayEvent));
    }

    protected void _saxZonedDateTime(ContentHandler handler, String tagName, ZonedDateTime zonedDatetime) throws SAXException {
        if (zonedDatetime != null) {
            XMLUtils.createElement((ContentHandler)handler, (String)tagName, (String)DateUtils.getISODateTimeFormatter().format(zonedDatetime));
        }
    }

    protected void _saxInstant(ContentHandler handler, String tagName, Instant instant) throws SAXException {
        if (instant != null) {
            this._saxZonedDateTime(handler, tagName, instant.atZone(ZoneOffset.UTC));
        }
    }

    public void saxICSErrors(List<IcsReader.IcsEvents> icsResults, ContentHandler handler) throws SAXException {
        List errorsIcs = icsResults.stream().filter(ics -> ics.getStatus() != IcsReader.IcsEvents.Status.OK).collect(Collectors.toList());
        if (!errorsIcs.isEmpty()) {
            XMLUtils.startElement((ContentHandler)handler, (String)"errors-ics");
            for (IcsReader.IcsEvents ics2 : errorsIcs) {
                AttributesImpl attrs = new AttributesImpl();
                attrs.addCDATAAttribute("url", ics2.getUrl());
                attrs.addCDATAAttribute("status", ics2.getStatus().name());
                XMLUtils.createElement((ContentHandler)handler, (String)"ics", (Attributes)attrs);
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"errors-ics");
        }
    }
}

