/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.calendar.search;

import java.time.ZonedDateTime;
import org.ametys.cms.search.query.AndQuery;
import org.ametys.cms.search.query.DateTimeQuery;
import org.ametys.cms.search.query.NotQuery;
import org.ametys.cms.search.query.OrQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.plugins.calendar.events.EventsFilterHelper;
import org.ametys.plugins.calendar.search.CalendarSearchService;
import org.ametys.web.frontoffice.search.requesttime.AbstractSearchComponent;
import org.ametys.web.frontoffice.search.requesttime.SearchComponentArguments;
import org.ametys.web.frontoffice.search.requesttime.impl.SearchComponentHelper;

public class DateRangeCriterionSearchComponent
extends AbstractSearchComponent {
    protected SearchComponentHelper _searchComponentHelper;

    public int getPriority() {
        return -7999;
    }

    public boolean supports(SearchComponentArguments args) {
        return CalendarSearchService.isFormSubmit(args) && CalendarSearchService.isActive(args);
    }

    public void execute(SearchComponentArguments args) throws Exception {
        EventsFilterHelper.DateTimeRange dateRange = CalendarSearchService.getDateRange(args);
        if (dateRange != null) {
            ZonedDateTime fromDateTime = dateRange.fromDate();
            ZonedDateTime untilDateTime = dateRange.untilDate();
            DateTimeQuery startBeforeQuery = new DateTimeQuery("start-date", Query.Operator.LT, untilDateTime);
            DateTimeQuery endAfterExpr = new DateTimeQuery("end-date", Query.Operator.GE, fromDateTime);
            DateTimeQuery startAfterExpr = new DateTimeQuery("start-date", Query.Operator.GE, fromDateTime);
            NotQuery noEndExpr = new NotQuery((Query)new DateTimeQuery("end-date"));
            args.searcher().addFilterQuery((Query)new AndQuery(new Query[]{startBeforeQuery, new OrQuery(new Query[]{endAfterExpr, new AndQuery(new Query[]{noEndExpr, startAfterExpr})})}));
        } else {
            args.searcher().addFilterQuery((Query)new DateTimeQuery("start-date"));
        }
    }
}

