/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

var ametys_calendars = {};

function createAmetysCalendar(id, config)
{
    // config.minDate [Date] start date of the calendar
    // config.maxDate [Date] end date of the calendar
    // config.rangeType [String] 'week' or 'month' (current view)
	// config.currentCategory [Array of String] The list of current categories
	// config.pdfDownload [boolean] true if the link as to be present
	// config.zoneItemId [String] the current zone id
	// config.events [Array of Event] contentId, eventId, title, start, end, abstract, description and optionnaly catNumber, catName, catLabel, path
	// config.months [Array of Month] start, year, month, str (e.g. 2011-12), label, weeks (Array of Week : start, end, previous, next, label, days (array of Day with date only))
	// config.categories [Array of Category] num, name, label
	// optionally config.linkURL [String] url of the link
	//            config.linkLabel [String] Label of the link
	
	ametys_calendars[id] = config;
    
    if (ametys_calendars[id].currentCategory)
    {
        if (!Array.isArray(ametys_calendars[id].currentCategory))
        {
            ametys_calendars[id].currentCategory = ametys_calendars[id].currentCategory.split(",");
        }
    }
    else
    {
        ametys_calendars[id].currentCategory = [];
    }
	
	var html = "";
	html += createAmetysCalendar.createHTML4Week(id) 
	html += createAmetysCalendar.createHTML4Month(id);
	html += createAmetysCalendar.createHTML4Legend(id, config.categories);
	html += createAmetysCalendar.createPDFLink(config.pdfDownload);
	if (config.icalDownload)
	{
	    html += createAmetysCalendar.createIcalLink(id);
	}
	html += createAmetysCalendar.createPageLink(config.linkURL, config.linkLabel);
	$j(id).html(html);
	
    
	var date = new Date();
    createAmetysCalendar.getCategories(id, createAmetysCalendar.displayAmetysCalendar, [id, date.getFullYear(), date.getMonth() + 1, date.getDate()]);
//	createAmetysCalendar.displayAmetysCalendar(id, date.getFullYear(), date.getMonth() + 1, date.getDate());
}

/** HTML Creation */
createAmetysCalendar.createPageLink = function(url, label)
{
	if (url != null && label != null)
	{
		return "<div class='link'><a href=\"" + url + "\">" + label + "</a></div>";
	}
	else
	{
		return "";
	}
}

createAmetysCalendar.createPDFLink = function(create)
{
	if (create)
	{
		return "<div class='pdf'><a href='#' target='_blank'>{{i18n CALENDAR_SERVICE_AGENDA_PDF}}</a></div>";
	}
	else
	{
		return "";
	}
}

createAmetysCalendar.getCurrentCategoriesString = function(id)
{
    var currentCategories = ametys_calendars[id].currentCategory;
    if (Array.isArray(currentCategories))
    {
        return currentCategories.join(",");
    }
    else
    {
        return currentCategories;
    }
}

createAmetysCalendar.getIcalLink = function(id)
{
    var currentDate = new Date();
    
    var url = createAmetysCalendar_getSiteUriPrefix('calendar')
            + '/' + ametys_calendars[id].siteName
            + '/' + ametys_calendars[id].language
            + '/' + ametys_calendars[id].zoneItemId
            + '/' + createAmetysCalendar.getCurrentCategoriesString(id) + '/agenda.ics';
    
    return url;
}

createAmetysCalendar.createIcalLink = function(id)
{
    var url = createAmetysCalendar.getIcalLink(id);
    
    return "<div class='ical'><a href='" + url + "' target='_blank'>{{i18n CALENDAR_SERVICE_AGENDA_ICAL}}</a></div>";
}

createAmetysCalendar.updateIcalLink = function(id)
{
    var icsLink = $j('.ical a', id);
    
    var url = createAmetysCalendar.getIcalLink(id);
    
    icsLink.attr('href', url);
}

createAmetysCalendar._createHTMLTableHeader = function(className, caption)
{
	var html = "<table class='" + className + "' summary=\"{{i18n CALENDAR_SERVICE_AGENDA_MONTH_SUMMARY}}\">"
	+ "<caption>" + caption + "</caption>"
	+ "<colgroup>"
	+     "<col width='75'/>"
	+     "<col width='75'/>"
	+     "<col width='75'/>"
	+     "<col width='75'/>"
	+     "<col width='75'/>"
	+     "<col width='75'/>"
	+     "<col width='75'/>"
	+ "</colgroup>"
	+ "<thead>"
	+ 	"<tr>"
	+ 		"<th scope='col'>{{i18n CALENDAR_SERVICE_AGENDA_MONDAY}}</th>"
	+ 		"<th scope='col'>{{i18n CALENDAR_SERVICE_AGENDA_TUESDAY}}</th>"
	+ 		"<th scope='col'>{{i18n CALENDAR_SERVICE_AGENDA_WEDNESDAY}}</th>"
	+ 		"<th scope='col'>{{i18n CALENDAR_SERVICE_AGENDA_THURSDAY}}</th>"
	+ 		"<th scope='col'>{{i18n CALENDAR_SERVICE_AGENDA_FRIDAY}}</th>"
	+ 		"<th scope='col'>{{i18n CALENDAR_SERVICE_AGENDA_SATURDAY}}</th>"
	+ 		"<th scope='col'>{{i18n CALENDAR_SERVICE_AGENDA_SUNDAY}}</th>"
	+ 	"</tr>"
	+ "</thead>";
	return html;
}
createAmetysCalendar._createHTMLTableWeek = function(number)
{
	var html = "<tr class='week-" + number + "'>";
	for (var j = 0; j < 7; j++)
	{
		html += "<td><span class='num'></span><div class='events'></div></td>";
	}
	html += "</tr>";
	return html;
}
createAmetysCalendar.createHTML4Week = function(id)
{
	var caption = "";	
	caption += 	"<div class='previous'>";
	caption += 		"<a href=\"javascript:createAmetysCalendar.previousWeek('" + id + "');\">{{i18n CALENDAR_SERVICE_AGENDA_PREVIOUS_WEEK}}</a>";
	caption += 	"</div>";
	caption += 	"<div class='next'>";
	caption += 		"<a href=\"javascript:createAmetysCalendar.nextWeek('" + id + "');\">{{i18n CALENDAR_SERVICE_AGENDA_NEXT_WEEK}}</a>";
	caption += 	"</div>";
	caption += 	"<div class='current'>";
	caption += 	"</div>";
	caption += 	"<div class='other-view'>";
	caption += 		"<a href=\"javascript:createAmetysCalendar.changeRange('" + id + "', 'month');\">{{i18n CALENDAR_SERVICE_AGENDA_MONTH}}</a>";
	caption += 	"</div>";
	
	var html = createAmetysCalendar._createHTMLTableHeader("week", caption);
	html += "<tbody>";
	html += createAmetysCalendar._createHTMLTableWeek(1);
	html += "</tbody>"
	html += "</table>"
	return html;
}
createAmetysCalendar.createHTML4Month = function(id)
{
	var caption = "";	
	caption += 	"<div class='previous'>";
	caption += 		"<a href=\"javascript:createAmetysCalendar.previousMonth('" + id + "');\">{{i18n CALENDAR_SERVICE_AGENDA_PREVIOUS_MONTH}}</a>";
	caption += 	"</div>";
	caption += 	"<div class='next'>";
	caption += 		"<a href=\"javascript:createAmetysCalendar.nextMonth('" + id + "');\">{{i18n CALENDAR_SERVICE_AGENDA_NEXT_MONTH}}</a>";
	caption += 	"</div>";
	caption += 	"<div class='current'>";
	caption += 	"</div>";
	caption += 	"<div class='other-view'>";
	caption += 		"<a href=\"javascript:createAmetysCalendar.changeRange('" + id + "', 'week');\">{{i18n CALENDAR_SERVICE_AGENDA_WEEK}}</a>";
	caption += 	"</div>";
	
	var html = createAmetysCalendar._createHTMLTableHeader("month", caption);
	html += "<tbody>";
	
	for (var i = 0; i < 6; i++)
	{
		html += createAmetysCalendar._createHTMLTableWeek(i+1);
	}
	
	html += "</tbody>"
	html += "</table>"
	return html;
}
createAmetysCalendar.createHTML4Legend = function(id, categories)
{
	if (categories.length > 0)
	{
		var html = "";
		html += "<div class='legend'>";
		html += 	"<ul>";
		html += 		"<li class='all'>";
		html += 			"<a href=\"javascript:createAmetysCalendar.changeCategory('" + id + "', 'all');\">{{i18n CALENDAR_SERVICE_AGENDA_ALL_EVENTS}}</a>";
		html += 		"</li>";
		
		for (var i = 0; i < categories.length; i++)
		{
			html += 		"<li class='category_" + categories[i].num + " category_" + categories[i].name + "'>";
			html +=				"<a href=\"javascript:createAmetysCalendar.changeCategory('" + id + "', '" + categories[i].name + "');\">" + categories[i].label + "</a>";
			html += 		"</li>";
		}
		
		html += 	"</ul>";
		html += "</div>";
		
		return html;
	}
	else
	{
		return "";
	}
}
createAmetysCalendar.displayAmetysCalendar = function(id, year, month, day)
{
    var currentDate = new Date(year, month - 1, day);
    
    if (currentDate.getTime() >= ametys_calendars[id].minDate.getTime() && currentDate.getTime() < ametys_calendars[id].maxDate.getTime())
    {
    	ametys_calendars[id].currentYear = year;
    	ametys_calendars[id].currentMonth = month;
    	ametys_calendars[id].currentDay = day;
        
    	createAmetysCalendar.displayCalendar(id, year, month, day);
    	createAmetysCalendar.displayCategory(id);
        
        if (ametys_calendars[id].pdfDownload)
        {
            createAmetysCalendar.updatePdfLink(id, year, month, day);
        }
        if (ametys_calendars[id].icalDownload)
        {
            createAmetysCalendar.updateIcalLink(id);
        }
    }
    else
    {
    	// asking for date out of our universe : do nothing
    }
}
createAmetysCalendar.changeRange = function(id, newRangeType)
{
	ametys_calendars[id].rangeType = newRangeType;
    
	createAmetysCalendar.displayAmetysCalendar(id, ametys_calendars[id].currentYear, ametys_calendars[id].currentMonth, ametys_calendars[id].currentDay);
}
createAmetysCalendar.changeCategory = function(id, newCategory)
{
    if (Array.isArray(newCategory))
    {
       ametys_calendars[id].currentCategory = newCategory;
    }
    else
    {
        ametys_calendars[id].currentCategory = [newCategory];
    }
    
    createAmetysCalendar.saveCategories(id);
    
    createAmetysCalendar.displayAmetysCalendar(id, ametys_calendars[id].currentYear, ametys_calendars[id].currentMonth, ametys_calendars[id].currentDay);
}
createAmetysCalendar.addCategory = function(id, newCategory)
{
    if (ametys_calendars[id].currentCategory.indexOf(newCategory) < 0)
    {
        ametys_calendars[id].currentCategory.push(newCategory);
    }
    
    createAmetysCalendar.saveCategories(id);
    
    createAmetysCalendar.displayAmetysCalendar(id, ametys_calendars[id].currentYear, ametys_calendars[id].currentMonth, ametys_calendars[id].currentDay);
}
createAmetysCalendar.removeCategory = function(id, newCategory)
{
    var pos = ametys_calendars[id].currentCategory.indexOf(newCategory);
    if (pos >= 0)
    {
        ametys_calendars[id].currentCategory.splice(pos, 1);
    }
    
    createAmetysCalendar.saveCategories(id);
    
    createAmetysCalendar.displayAmetysCalendar(id, ametys_calendars[id].currentYear, ametys_calendars[id].currentMonth, ametys_calendars[id].currentDay);
}
createAmetysCalendar.saveCategories = function(id, callback, args)
{
    $j.ajax({
        url: createAmetysCalendar_getSiteUriPrefix('calendar') + '/set-categories.json',
        method: 'POST',
        data: {
            zoneItemId: ametys_calendars[id].zoneItemId,
            categories: ametys_calendars[id].currentCategory
        },
        cache: false,
        dataType: 'json',
        success: function(data) {
            if (typeof callback == "function")
            {
                var myArgs = args;
                myArgs.push(data);
                callback.apply(this, myArgs);
            }
        },
        error: function() {
            if (typeof callback == "function")
            {
                var myArgs = args;
                myArgs.push(data);
                callback.apply(this, myArgs);
            }
        }
    });
}
createAmetysCalendar.getCategories = function(id, callback, args)
{
    $j.ajax({
        url: createAmetysCalendar_getSiteUriPrefix('calendar') + '/get-categories.json',
        method: 'POST',
        data: {
            zoneItemId: ametys_calendars[id].zoneItemId
        },
        cache: false,
        dataType: 'json',
        success: function(data) {
            ametys_calendars[id].currentCategory = data.categories;
            if (typeof callback == "function")
            {
                var myArgs = args;
                myArgs.push(data);
                callback.apply(this, myArgs);
            }
        },
        error: function() {
            if (typeof callback == "function")
            {
                var myArgs = args;
                myArgs.push(data);
                callback.apply(this, myArgs);
            }
        }
    });
}
createAmetysCalendar.displayCalendar = function(id, year, month, day)
{
    var table = $j(ametys_calendars[id].rangeType == 'month' ? 'table.month' : 'table.week', id);
    table.show();
    
    var otherTable = $j(ametys_calendars[id].rangeType == 'month' ? 'table.week' : 'table.month', id);
    otherTable.hide();
    
    if (ametys_calendars[id].rangeType == 'week')
    {
        var week = createAmetysCalendar.getWeek(id, year, month, day);
        
        createAmetysCalendar.updateWeekNavigation(week, id, table, year, month, day);
        createAmetysCalendar.displayWeek(week, id, table, year, month, day);
    }
    else
    {
        var monthIndex = createAmetysCalendar.getMonthIndex(id, year, month);
        
        createAmetysCalendar.updateMonthNavigation(monthIndex, id, table, year, month, day);
        createAmetysCalendar.displayMonth(monthIndex, id, table, year, month, day);
    }
}
createAmetysCalendar.getMonthIndex = function(id, yearNum, monthNum)
{
    for (var i = 0; i < ametys_calendars[id].months.length; i++)
    {
        if (ametys_calendars[id].months[i].year == yearNum && ametys_calendars[id].months[i].month == monthNum)
        {
            return i;
        }
    }
    
    return 0;
}
createAmetysCalendar.getWeek = function(id, yearNum, monthNum, dayNum)
{
    var date = new Date(yearNum, monthNum - 1, dayNum);
    
    var monthIndex = createAmetysCalendar.getMonthIndex(id, yearNum, monthNum);
    var weeks = ametys_calendars[id].months[monthIndex].weeks;
    
    for (var i = 0; i < weeks.length; i++)
    {
        if (createAmetysCalendar.belongsToWeek(date, weeks[i]))
        {
            return weeks[i];
        }
    }
}
createAmetysCalendar.belongsToWeek = function(date, week)
{
    return date.getTime() >= week.start.getTime() && date.getTime() <= week.end.getTime();
}
createAmetysCalendar.displayMonth = function(currentMonth, id, $table, yearNum, monthNum, dayNum)
{
	var today = new Date();

    var month = ametys_calendars[id].months[currentMonth];
    var weeks = month.weeks;
    for (var j = 0; j < weeks.length; j++)
    {
        var $weekRow = $j('tbody tr:eq(' + j + ')', $table);
        
        var days = weeks[j].days;
        for (var k = 0; k < days.length; k++)
        {
            var day = days[k].date;


            var $dayCell = $j('td', $weekRow).eq(k);

            $dayCell.removeClass();
            $dayCell.addClass('day');
            $dayCell.addClass('day' + day.getDate());
            if (day.getFullYear() != yearNum || day.getMonth() != (monthNum - 1))
            {
            	$dayCell.addClass('outside');
            }
            if (day.getFullYear() == today.getFullYear() && day.getMonth() == today.getMonth() && day.getDate() == today.getDate())
            {
            	$dayCell.addClass('today');
            }
            
            $j('.num', $dayCell).html("<span class='hidden-L'>" + day.getFullYear() + "-" + day.getMonth() + "-" + "</span>" + day.getDate());

            var $eventsDiv = $j('.events', $dayCell);
            $eventsDiv.empty();
        	createAmetysCalendar.addEvents(id, day, $eventsDiv);
        }
    }
    
    $j('tbody tr:eq(5)', $table).toggle(weeks.length > 5);
}
createAmetysCalendar.displayWeek = function(week, id, $table, yearNum, monthNum, dayNum)
{
	var today = new Date();

    for (var i = 0; i < week.days.length; i++)
    {
        var day = week.days[i].date;
        
        var $dayCell = $j('tbody tr:eq(0) td', $table).eq(i);
        $dayCell.removeClass();
        $dayCell.addClass('day');
        $dayCell.addClass('day' + day.getDate());
        if (day.getFullYear() == today.getFullYear() && day.getMonth() == today.getMonth() && day.getDate() == today.getDate())
        {
        	$dayCell.addClass('today');
        }

        $j('.num', $dayCell).text(day.getDate());
        
        var $eventsDiv = $j('.events', $dayCell);
        $eventsDiv.empty();
        createAmetysCalendar.addEvents(id, day, $eventsDiv);
    }
}
createAmetysCalendar.addEvents = function(id, day, $eventsDiv)
{
	for (var i = 0; i < ametys_calendars[id].events.length; i++)
    {
        var event = ametys_calendars[id].events[i];
        
        if (createAmetysCalendar.isEvent(day, event))
        {
            var className = 'event';
            if (event.catNumber)
            {
                className += ' ' + event.catNumber;
            }
            if (event.catName)
            {
                className += ' ' + event.catName;
            }
            
            var eventCode = "<span class='event-category-title'>" + (event.catLabel || '') + "</span>";
            if (event.path)
            {
            	eventCode += "<a href=\"" + event.path + "\">"
            }
            eventCode += event.title;
            if (event.path)
            {
            	eventCode += "</a>"
            }
            
            $eventsDiv.append("<div class='" + className + "'><span class='title'>" + eventCode + "</span></div>");
            if (!$eventsDiv.parent().hasClass("hasevent"))
            {
            	$eventsDiv.parent().addClass("hasevent");
            }
        }
    }
}
createAmetysCalendar.isEvent = function(date, event)
{
    var isEvent = false;
    
    var start = event.start;
    var end = event.end;
    
    if (start == null && end != null)
    {
        isEvent = date.getFullYear() == end.getFullYear() && date.getMonth() == end.getMonth() && date.getDate() == end.getDate();
    }
    else if (start != null && end == null)
    {
        isEvent = date.getFullYear() == start.getFullYear() && date.getMonth() == start.getMonth() && date.getDate() == start.getDate();
    }
    else if (start != null && end != null)
    {
        isEvent = (date.getTime() >= start.getTime() && date.getTime() <= end.getTime());
    }
    
    return isEvent;
}
createAmetysCalendar.updatePdfLink = function(id, year, month, day)
{
    var pdfLink = $j('.pdf a', id);
    
    var url = createAmetysCalendar_getSiteUriPrefix('calendar')
            + '/' + ametys_calendars[id].siteName + '/' + ametys_calendars[id].language
            + '/' + year + '/' + createAmetysCalendar.zeroPad(month) + '/' + createAmetysCalendar.zeroPad(day)
            + '/' + ametys_calendars[id].zoneItemId + '/' + ametys_calendars[id].rangeType + '/' + createAmetysCalendar.getCurrentCategoriesString(id) + '/agenda.pdf';
    
    pdfLink.attr('href', url);
}
createAmetysCalendar.previousMonth = function(id)
{
    var previousYear = ametys_calendars[id].currentMonth > 1 ? ametys_calendars[id].currentYear : ametys_calendars[id].currentYear - 1;
    var previousMonth = ametys_calendars[id].currentMonth > 1 ? ametys_calendars[id].currentMonth - 1 : 12;

	createAmetysCalendar.displayAmetysCalendar(id, previousYear, previousMonth, 1);
}
createAmetysCalendar.nextMonth = function(id)
{
	var nextYear = ametys_calendars[id].currentMonth < 12 ? ametys_calendars[id].currentYear : ametys_calendars[id].currentYear + 1;
    var nextMonth = ametys_calendars[id].currentMonth < 12 ? ametys_calendars[id].currentMonth + 1 : 1;

	createAmetysCalendar.displayAmetysCalendar(id, nextYear, nextMonth, 1);
}
createAmetysCalendar.previousWeek = function(id)
{
    var week = createAmetysCalendar.getWeek(id, ametys_calendars[id].currentYear, ametys_calendars[id].currentMonth, ametys_calendars[id].currentDay);
	createAmetysCalendar.displayAmetysCalendar(id, week.previous.getFullYear(), week.previous.getMonth() + 1, week.previous.getDate());
}
createAmetysCalendar.nextWeek = function(id)
{
    var week = createAmetysCalendar.getWeek(id, ametys_calendars[id].currentYear, ametys_calendars[id].currentMonth, ametys_calendars[id].currentDay);
	createAmetysCalendar.displayAmetysCalendar(id, week.next.getFullYear(), week.next.getMonth() + 1, week.next.getDate());
}
createAmetysCalendar.updateWeekNavigation = function(week, id, $table, yearNum, monthNum, dayNum)
{
    $j('table.week caption .current', id).text(week.label);
    
    
    if (week.previous < ametys_calendars[id].minDate)
    {
    	$j('table.week caption .previous', id).addClass("hidden");
    }
    else
    {
    	$j('table.week caption .previous', id).removeClass("hidden");
    }
    
    if (week.next >= ametys_calendars[id].maxDate)
    {
    	$j('table.week caption .next', id).addClass("hidden");
    }
    else
    {
    	$j('table.week caption .next', id).removeClass("hidden");
    }
}
createAmetysCalendar.updateMonthNavigation = function(currentMonth, id, $table, yearNum, monthNum, dayNum)
{
	var month = ametys_calendars[id].months[currentMonth];
    $j('table.month caption .current', id).text(month.label);
    
    if (currentMonth <= 0)
    {
    	$j('table.month caption .previous', id).addClass("hidden");
    }
    else
    {
    	$j('table.month caption .previous', id).removeClass("hidden");
    }
    
    if (currentMonth >= ametys_calendars[id].months.length - 1)
    {
    	$j('table.month caption .next', id).addClass("hidden");
    }
    else
    {
    	$j('table.month caption .next', id).removeClass("hidden");
    }
}
createAmetysCalendar.displayCategory = function(id)
{
	$j('.legend li', id).removeClass("current");
	if (ametys_calendars[id].currentCategory.indexOf("all") >= 0)
	{
		$j('.legend .all', id).addClass("current");
		$j('table div.event', id).show();
	}
	else
	{
        $j('table div.event', id).hide();
        for (var i = 0; i < ametys_calendars[id].currentCategory.length; i++)
        {
            $j('.legend .category_' + ametys_calendars[id].currentCategory[i], id).addClass("current");
            $j('table div.category_' + ametys_calendars[id].currentCategory[i], id).show();
        }
	}
}
createAmetysCalendar.zeroPad = function(number)
{
    var str;
    if (number >= 0 && number < 10)
    {
        str = '0' + number;
    }
    else
    {
        str = '' + number;
    }
    return str;
}
