/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.calendar.search;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.tag.Tag;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.IgnoreRootHandler;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.calendar.search.CalendarContentReturnable;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.web.WebConstants;
import org.ametys.web.contenttype.SkinContentViewHelper;
import org.ametys.web.frontoffice.search.metamodel.impl.AbstractContentBasedReturnable;
import org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer;
import org.ametys.web.frontoffice.search.requesttime.SearchComponentArguments;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.site.Site;
import org.apache.cocoon.components.source.impl.SitemapSource;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.slf4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CalendarContentSaxer
extends ContentSaxer {
    private SkinContentViewHelper _skinContentViewHelper;

    public CalendarContentSaxer(AbstractContentBasedReturnable contentReturnable, String view, ContentTypesHelper cTypesHelper, SkinContentViewHelper skinContentViewHelper, Collection<String> contentTypes) {
        super(contentReturnable, view, cTypesHelper, contentTypes);
        this._skinContentViewHelper = skinContentViewHelper;
    }

    public void sax(ContentHandler contentHandler, AmetysObject hit, Logger logger, SearchComponentArguments args) throws SAXException {
        Content content = (Content)hit;
        String modelViewName = this._view;
        SkinContentViewHelper.SkinContentView skinContentView = this._skinContentViewHelper.getContentViewFromSkin(this._view, content);
        if (skinContentView != null) {
            modelViewName = skinContentView.modelViewName();
        }
        View view = this._cTypesHelper.getView(modelViewName, content);
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", content.getId());
        attrs.addCDATAAttribute("name", content.getName());
        attrs.addCDATAAttribute("title", content.getTitle(null));
        attrs.addCDATAAttribute("createdAt", DateUtils.zonedDateTimeToString((ZonedDateTime)content.getCreationDate()));
        attrs.addCDATAAttribute("creator", UserIdentity.userIdentityToString((UserIdentity)content.getCreator()));
        attrs.addCDATAAttribute("lastModifiedAt", DateUtils.zonedDateTimeToString((ZonedDateTime)content.getLastModified()));
        Optional.ofNullable(content.getLanguage()).ifPresent(lang -> attrs.addCDATAAttribute("language", lang));
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"content", (Attributes)attrs);
        String[] contentTypes = content.getTypes();
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"contentTypes");
        Arrays.asList(contentTypes).forEach(LambdaUtils.wrapConsumer(cType -> XMLUtils.createElement((ContentHandler)contentHandler, (String)"contentType", (String)cType)));
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"contentTypes");
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"attributes");
        Locale defaultLocale = this.getDefaultLocale(args.request(), args);
        content.dataToSAX(contentHandler, (ViewItemAccessor)view, DataContext.newInstance().withLocale(defaultLocale).withEmptyValues(false));
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"attributes");
        this.saxHtmlView(contentHandler, content, args, logger);
        this.saxTags(content, contentHandler);
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"content");
    }

    protected Locale getDefaultLocale(Request request, SearchComponentArguments args) {
        String lang = args.generatorParameters().getParameter("lang", request.getParameter("lang"));
        return StringUtils.isNotEmpty((CharSequence)lang) ? LocaleUtils.toLocale((String)lang) : Locale.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saxHtmlView(ContentHandler contentHandler, Content content, SearchComponentArguments args, Logger logger) throws SAXException {
        Request request = args.request();
        String currentSiteName = (String)request.getAttribute("site");
        Site currentSite = (Site)request.getAttribute(WebConstants.REQUEST_ATTR_SITE);
        String currentSkinName = (String)request.getAttribute("skin");
        try {
            request.setAttribute("finalsite", (Object)currentSiteName);
            request.setAttribute("finalskin", (Object)currentSkinName);
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"view");
            if (this._contentReturnable instanceof CalendarContentReturnable) {
                String uri = this._contentReturnable.getContentHelper().getContentHtmlViewUrl(content, this._view);
                SitemapSource src = null;
                try {
                    src = (SitemapSource)((CalendarContentReturnable)this._contentReturnable)._srcResolver.resolveURI(uri);
                    src.toSAX((ContentHandler)new IgnoreRootHandler(contentHandler));
                }
                finally {
                    ((CalendarContentReturnable)this._contentReturnable)._srcResolver.release((Source)src);
                }
            }
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"view");
        }
        catch (IOException e) {
            logger.error("Unable to sax HTML view for content '{}'", (Object)content.getId(), (Object)e);
        }
        finally {
            request.removeAttribute("finalsite");
            request.removeAttribute("finalskin");
            request.setAttribute("site", (Object)currentSiteName);
            request.setAttribute(WebConstants.REQUEST_ATTR_SITE, (Object)currentSite);
            request.setAttribute("siteName", (Object)currentSiteName);
            request.setAttribute("skin", (Object)currentSkinName);
        }
    }

    protected void saxTags(Content content, ContentHandler contentHandler) throws SAXException {
        if (this._contentReturnable instanceof CalendarContentReturnable) {
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"tags");
            Set tags = content.getTags();
            for (String tagName : tags) {
                Tag tag;
                HashMap<String, String> contextParameters = new HashMap<String, String>();
                if (content instanceof WebContent) {
                    contextParameters.put("siteName", ((WebContent)content).getSiteName());
                }
                if ((tag = ((CalendarContentReturnable)this._contentReturnable).getTagProviderExtensionPoint().getTag(tagName, contextParameters)) == null) continue;
                AttributesImpl attrs = new AttributesImpl();
                if (tag.getParentName() != null) {
                    attrs.addCDATAAttribute("parent", tag.getParentName());
                }
                XMLUtils.startElement((ContentHandler)contentHandler, (String)tagName, (Attributes)attrs);
                tag.getTitle().toSAX(contentHandler);
                XMLUtils.endElement((ContentHandler)contentHandler, (String)tagName);
            }
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"tags");
        }
    }
}

