/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.calendar.search;

import java.time.ZonedDateTime;
import java.util.List;
import org.ametys.cms.search.SearchResults;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.calendar.events.EventsFilterHelper;
import org.ametys.plugins.calendar.icsreader.IcsEventHelper;
import org.ametys.plugins.calendar.icsreader.IcsReader;
import org.ametys.plugins.calendar.icsreader.LocalVEvent;
import org.ametys.plugins.calendar.search.CalendarSearchService;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.web.frontoffice.search.instance.SearchServiceInstance;
import org.ametys.web.frontoffice.search.requesttime.SearchComponentArguments;
import org.ametys.web.frontoffice.search.requesttime.impl.SaxResultsSearchComponent;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CalendarSearchComponent
extends SaxResultsSearchComponent
implements Serviceable {
    private IcsEventHelper _icsEventHelper;
    private AmetysObjectResolver _resolver;

    public void service(ServiceManager smanager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._icsEventHelper = (IcsEventHelper)smanager.lookup(IcsEventHelper.ROLE);
    }

    public boolean supports(SearchComponentArguments args) {
        return CalendarSearchService.isFormSubmit(args) && CalendarSearchService.isActive(args);
    }

    public void execute(SearchComponentArguments args) throws Exception {
        SearchResults aoResults = this.getResults(args);
        String zoneItemId = args.serviceInstance().getId();
        ZoneItem zoneItem = (ZoneItem)this._resolver.resolveById(zoneItemId);
        EventsFilterHelper.DateTimeRange dateRange = CalendarSearchService.getDateRange(args);
        List<IcsReader.IcsEvents> icsResults = args.generatorParameters().getParameterAsBoolean("export", false) ? this._icsEventHelper.getICSEvents(zoneItem, args.currentSite().getName(), dateRange, Long.MAX_VALUE, Long.MAX_VALUE) : this._icsEventHelper.getICSEvents(zoneItem, args.currentSite().getName(), dateRange);
        ContentHandler handler = args.contentHandler();
        int aoTotal = this.total(aoResults, args.serviceInstance());
        int total = aoTotal + icsResults.size();
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("total", String.valueOf(total));
        XMLUtils.startElement((ContentHandler)handler, (String)"hits", (Attributes)atts);
        SearchServiceInstance service = args.serviceInstance();
        this.saxHits(aoResults, 0, args, service.getReturnables(), service.getAdditionalParameterValues());
        List<String> selectedTags = CalendarSearchService.getSelectedTags(args);
        this.saxICSHits(handler, icsResults, dateRange, selectedTags, aoTotal);
        XMLUtils.endElement((ContentHandler)handler, (String)"hits");
        this.saxDangeRange(handler, dateRange, total);
        this._icsEventHelper.saxICSErrors(icsResults, handler);
    }

    protected void saxICSHits(ContentHandler handler, List<IcsReader.IcsEvents> icsResults, EventsFilterHelper.DateTimeRange dateRange, List<String> filteredTags, int start) throws SAXException {
        Pair<List<LocalVEvent>, String> localIcsEvents = this._icsEventHelper.toLocalIcsEvent(icsResults, dateRange, filteredTags);
        List icsHits = (List)localIcsEvents.getLeft();
        this._icsEventHelper.saxIcsEventHits(handler, icsHits, start);
        String fullICSDistantEvents = (String)localIcsEvents.getRight();
        XMLUtils.createElement((ContentHandler)handler, (String)"rawICS", (String)fullICSDistantEvents);
        String timezones = this._icsEventHelper.toVTimeZone(icsResults, dateRange, List.of());
        XMLUtils.createElement((ContentHandler)handler, (String)"timezones", (String)timezones);
    }

    protected void saxDangeRange(ContentHandler handler, EventsFilterHelper.DateTimeRange dateRange, int total) throws SAXException {
        if (dateRange != null) {
            AttributesImpl atts = new AttributesImpl();
            atts.addCDATAAttribute("total", String.valueOf(total));
            atts.addCDATAAttribute("start", DateUtils.zonedDateTimeToString((ZonedDateTime)dateRange.fromDate()));
            atts.addCDATAAttribute("end", DateUtils.zonedDateTimeToString((ZonedDateTime)dateRange.untilDate()));
            XMLUtils.createElement((ContentHandler)handler, (String)"date-range", (Attributes)atts);
        }
    }
}

