/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.calendar.search;

import org.ametys.web.frontoffice.search.requesttime.SearchComponent;
import org.ametys.web.frontoffice.search.requesttime.SearchComponentArguments;
import org.ametys.web.frontoffice.search.requesttime.impl.SaxGeneralDataSearchComponent;

/**
 * {@link SearchComponent} for saxing general data for calendar search service
 * Reactivate default {@link SaxGeneralDataSearchComponent} (disabled by "disableDefaultSax" parameter)
 */
public class CalendarSaxGeneralDataSearchComponent extends SaxGeneralDataSearchComponent
{
    @Override
    public boolean supports(SearchComponentArguments args)
    {
        return CalendarSearchService.isActive(args);
    }
}
