/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.calendar.search;

import org.apache.cocoon.environment.Request;

import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.web.frontoffice.search.instance.SearchServiceInstance;
import org.ametys.web.frontoffice.search.requesttime.SearchServiceGenerator;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.page.ZoneItem.ZoneType;

/**
 * Generator for search service on calendar events
 *
 */
public class CalendarSearchServiceGenerator extends SearchServiceGenerator
{
    @Override
    protected SearchServiceInstance getInstance(Request request, String zoneItemId)
    {
        ZoneItem zoneItem = null;
        try
        {
            zoneItem = _ametysObjectResolver.resolveById(zoneItemId);
            
        }
        catch (AmetysRepositoryException e)
        {
            // Nothing
        }
        
        if (zoneItem != null && zoneItem.getType() == ZoneType.SERVICE && CalendarSearchService.SERVICE_ID.equals(zoneItem.getServiceId()))
        {
            return _searchServiceInstanceManager.get(zoneItemId);
        }
        else
        {
            throw new IllegalArgumentException("No search service instance in zone item '" + zoneItemId + "'");
        }
    }
}
