<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:docbook="http://docbook.org/ns/docbook"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:exsl="http://exslt.org/common"
    xmlns:math="java.lang.Math"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
    xmlns:encoder="java.net.URLEncoder"
    extension-element-prefixes="resolver exsl math escaper ametys encoder">
    
    <xsl:variable name="cms-context" select="ametys:siteUriPrefix()"/>
    <xsl:variable name="contextPath" select="ametys:uriPrefix()"/>
    <xsl:variable name="site" select="ametys:site()"/>
    <xsl:variable name="lang" select="ametys:lang()"/>
    
    <xsl:variable name="title" select="ametys:serviceParameter('title')/text()"/>
    <xsl:variable name="months-before" select="ametys:serviceParameter('months-before', '3')/text()"/>
    <xsl:variable name="months-after" select="ametys:serviceParameter('months-after', '3')/text()"/>
    <xsl:variable name="contents-on-same-page" select="ametys:serviceParameter('contents-on-same-page')/text()"/>
    <xsl:variable name="link" select="ametys:serviceParameter('link')/text()"/>
    <xsl:variable name="link-title" select="ametys:serviceParameter('link-title')/text()"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    <xsl:variable name="eventTemplateName">page</xsl:variable>
    
    <xsl:template match="/">
        <html>
            <head>
                <script type="text/javascript">
                var events<xsl:value-of select="$uniqueId"/> = [];
                var samePage<xsl:value-of select="$uniqueId"/> = <xsl:value-of select="$contents-on-same-page"/>;
                
                <xsl:apply-templates select="events/contents/event[pages/page]" mode="calendar"/>
                
                var beforeShowDay<xsl:value-of select="$uniqueId"/> = function(date)
                {
                    var events = events<xsl:value-of select="$uniqueId"/>;
                    var eventsCount = 0;
                    for (var i = 0; i &lt; events.length; i++)
                    {
                        if (isEvent(date, events[i]))
                        {
                            eventsCount++;
                        }
                    }
                    
                    return [eventsCount &gt; 0, '', '<i18n:text i18n:key="CALENDAR_SERVICE_CALENDAR_EVENTS_COUNT"/> ' + eventsCount];
                }
                
                var onSelect<xsl:value-of select="$uniqueId"/> = function(dateText, inst)
                {
                    var events = events<xsl:value-of select="$uniqueId"/>;
                    
                    var date = $j.datepicker.parseDate('yy-mm-dd', dateText);
                    
                    if (samePage<xsl:value-of select="$uniqueId"/>)
                    {
                        var html = '';
                        
                        for (var i = 0; i &lt; events.length; i++)
                        {
                            var startingMonth = events[i].start.substring(0,events[i].start.length - 3);  
                            if (isEvent(date, events[i]))
                            {
                                var id =  'event-' + startingMonth + '-<xsl:value-of select="$uniqueId"/>-' + events[i].eventId;
                                html += $j('#' + id).html();
                            }
                        }
                        
                        if (html != '')
                        {
                            $j("#day-events-<xsl:value-of select="$uniqueId"/> .date").html($j.datepicker.formatDate('d MM yy', date));
                            $j("#day-events-<xsl:value-of select="$uniqueId"/> .list").html(html);
                            $j('.events').show();
                        }
                        else
                        {
                            $j('.events').hide();
                        }
                    }
                    else
                    {
                        var dateStr = $j.datepicker.formatDate('yy/mm/dd', date);
                        var eventsUrl = '<xsl:value-of select="concat($cms-context, '/', $lang, '/_plugins/calendar/', $eventTemplateName, '/')"/>' + dateStr + '/' + encodeURIComponent(encodeURIComponent('<xsl:value-of select="/events/@zoneItemId"/>')) + '/events.html';
		                <xsl:choose>
		                    <xsl:when test="ametys:renderingContext() = 'back'">
		                          window.open(eventsUrl); 
		                    </xsl:when>
		                    <xsl:otherwise>
		                          document.location.href = eventsUrl;
		                    </xsl:otherwise>
		                </xsl:choose>
                        document.location.href = eventsUrl;
                    }
                }
                
                var isEvent = function(date, event)
                {
                    var isEvent = false;
                    
                    var start = $j.datepicker.parseDate('yy-mm-dd', event.start);
                    var end = $j.datepicker.parseDate('yy-mm-dd', event.end);
                    
                    if (start == null &amp;&amp; end != null)
                    {
                        isEvent = date.getFullYear() == end.getFullYear() &amp;&amp; date.getMonth() == end.getMonth() &amp;&amp; date.getDate() == end.getDate();
                    }
                    else if (start != null &amp;&amp; end == null)
                    {
                        isEvent = date.getFullYear() == start.getFullYear() &amp;&amp; date.getMonth() == start.getMonth() &amp;&amp; date.getDate() == start.getDate();
                    }
                    else if (start != null &amp;&amp; end != null)
                    {
                        isEvent = (date.getTime() &gt;= start.getTime() &amp;&amp; date.getTime() &lt;= end.getTime());
                    }
                    
                    return isEvent;
                }
                
                $j(function() {
                    $j("#all-events-<xsl:value-of select="$uniqueId"/>").hide();
                    $j("#calendar-<xsl:value-of select="$uniqueId"/>").datepicker({
                        <!-- Range -->
                        minDate: '-<xsl:value-of select="$months-before"/>M',
                        maxDate: '+<xsl:value-of select="$months-after"/>M',
                        <!-- Date format -->
                        dateFormat: 'yy-mm-dd',
                        <!-- Event handlers. -->
                        beforeShowDay: beforeShowDay<xsl:value-of select="$uniqueId"/>,
                        onSelect: onSelect<xsl:value-of select="$uniqueId"/>
                    });
                });
                </script>
            </head>
            
            <body id="default">
                <div class="events-calendar">
                	<xsl:if test="$title != ''">
	                    <h1 class="title"><xsl:value-of select="$title"/></h1>
                	</xsl:if>
                    <div id="calendar-{$uniqueId}" class="calendar"/>
                    <div id="day-events-{$uniqueId}" class="events" style="display:none">
                        <h2>
                            <span class="date">
                                <!-- Day placeholder -->
                            </span>
                        </h2>
                        <div class="list">
                            <!-- Events placeholder -->
                        </div>
                    </div>
                    <xsl:if test="events/contents/event">
                    <div id="all-events-{$uniqueId}">
		                <xsl:choose>
		                    <xsl:when test="$contents-on-same-page = 'false'"> 
		                                        <ul>
		                                            <xsl:for-each select="/events/calendar-months/month/calendar/week[position() != 1 or preceding::week[1]/day[position() = 1]/@raw != day[1]/@raw]/day">
		                                                <xsl:variable name="day" select="."/>
		                                                <xsl:variable name="nbEvents" select="count(/events/contents/event[@start = $day/@date or @end = $day/@date or (number(translate(@start, '-', '')) &lt;= number(translate($day/@date, '-', '')) and number(translate(@end, '-', '')) &gt;= number(translate($day/@date, '-', '')))])"/>
		                                                <xsl:if test="$nbEvents &gt; 0">
		                                                    <li class="day {@day}">
		                                                            <a href="{$cms-context}/{$lang}/_plugins/calendar/{$eventTemplateName}/{@year}/{@month}/{@day}/{encoder:encode(encoder:encode(/events/@zoneItemId, 'utf-8'), 'utf-8')}/events_1.3.html">
		                                                                <span>
		                                                                    <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="dd MMMM yyyy" value="{@raw}"/>
		                                                                </span>
		                                                                <xsl:text> </xsl:text>
		                                                                <i18n:text i18n:key="CALENDAR_SERVICE_CALENDAR_EVENTS_COUNT"/>
		                                                                <xsl:text> </xsl:text>
		                                                                <xsl:value-of select="$nbEvents"/>
		                                                            </a>
		                                                    </li>
		                                                </xsl:if>
		                                            </xsl:for-each>
		                                        </ul>
		                    </xsl:when>
		                    <xsl:otherwise>
		                                        <ul>
		                                            <xsl:for-each select="/events/months/month">
		                                                <xsl:if test="/events/contents/event[starts-with(content/metadata/start-date, current()/@str)]">
		                                                    <li class="month {@str}">
		                                                        <span>
		                                                            <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="MMMM yyyy" value="{@raw}"/>
		                                                        </span>
		                                                        <ul>
                                                                    <xsl:variable name="str" select="@str"/>
		                                                            <xsl:for-each select="/events/contents/event[starts-with(content/metadata/start-date, current()/@str)]">
		                                                                <li id="event-{$str}-{$uniqueId}-{substring-after(content/@id, '//')}" class="event">
		                                                                    <xsl:copy-of select="view/content/html/body/node()"/>
		                                                                </li>
		                                                            </xsl:for-each>
		                                                        </ul>
		                                                    </li>
		                                                </xsl:if>
		                                            </xsl:for-each>
		                                        </ul>
		                    </xsl:otherwise>
		                </xsl:choose>                    
                    </div>
                    </xsl:if>
                    <xsl:if test="starts-with($link, 'page://')">
                        <xsl:variable name="url" select="resolver:resolve('page', $link)"/>
                        <xsl:if test="$url != ''">
                            <div class="link">
                                <a href="{$url}">
                                    <xsl:choose>
                                        <xsl:when test="$link-title != ''">
                                            <xsl:value-of select="$link-title"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                        	<xsl:value-of select="ametys:pageTitle($link)"/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </a>
                            </div>
                        </xsl:if>
                    </xsl:if>
                </div>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template match="event" mode="calendar">
        events<xsl:value-of select="$uniqueId"/>.push({
            contentId: "<xsl:value-of select="content/@id"/>",
            eventId: "<xsl:value-of select="substring-after(content/@id, '//')"/>",
            title: "<xsl:value-of select="escaper:escapeJavaScript(content/metadata/title)"/>",
            start: "<xsl:if test="content/metadata/start-date"><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="yyyy-MM-dd" value="{content/metadata/start-date}"/></xsl:if>",
            end: "<xsl:if test="content/metadata/end-date"><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="yyyy-MM-dd" value="{content/metadata/end-date}"/></xsl:if>",
            abstract: "<xsl:value-of select="escaper:escapeJavaScript(content/metadata/abstract)"/>"
            <xsl:if test="pages/page">
            ,path: "<xsl:value-of select="concat(pages/page[1]/@lang, '/', pages/page[1]/@path)"/>"
            </xsl:if>
        });
    </xsl:template>
    
    <xsl:template match="content" mode="list">
    </xsl:template>
    
</xsl:stylesheet>
