/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.calendar.events;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.filter.ContentFilter;
import org.ametys.cms.filter.ContentFilterExtensionPoint;
import org.ametys.cms.tag.Tag;
import org.ametys.cms.tag.TagProviderExtensionPoint;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.calendar.events.EventsFilter;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelAwareRepeaterEntry;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.DateExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.MetadataExpression;
import org.ametys.plugins.repository.query.expression.NotExpression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.web.filter.WebContentFilter;
import org.ametys.web.frontoffice.search.instance.model.SiteContextType;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class EventsFilterHelper
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = EventsFilterHelper.class.getName();
    public static final String START_DATE_META = "start-date";
    public static final String END_DATE_META = "end-date";
    public static final String EVENTS_FILTER_ID = "events";
    protected TagProviderExtensionPoint _tagProviderEP;
    protected ContentFilterExtensionPoint _filterExtPt;
    protected AmetysObjectResolver _ametysResolver;
    protected ContentTypeExtensionPoint _contentTypeEP;
    protected SiteManager _siteManager;
    protected JSONUtils _jsonUtils;

    public void service(ServiceManager manager) throws ServiceException {
        this._tagProviderEP = (TagProviderExtensionPoint)manager.lookup(TagProviderExtensionPoint.ROLE);
        this._filterExtPt = (ContentFilterExtensionPoint)manager.lookup(ContentFilterExtensionPoint.ROLE);
        this._ametysResolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._contentTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
    }

    public EventsFilter createEventsFilter(String id) {
        EventsFilter eventsFilter = (EventsFilter)((Object)this._filterExtPt.getExtension(EVENTS_FILTER_ID));
        return new EventsFilter(id, eventsFilter, this._ametysResolver, this._contentTypeEP, this._siteManager, this._tagProviderEP);
    }

    public String getTitle(ZoneItem zoneItem) {
        return (String)zoneItem.getServiceParameters().getValue("title", false, (Object)"");
    }

    public String getLink(ZoneItem zoneItem) {
        return (String)zoneItem.getServiceParameters().getValue("link", false, (Object)"");
    }

    public String getLinkTitle(ZoneItem zoneItem) {
        return (String)zoneItem.getServiceParameters().getValue("link-title", false, (Object)"");
    }

    public String getDefaultRangeType(ZoneItem zoneItem) {
        ModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
        return serviceParameters.hasDefinition("default-range") ? (String)serviceParameters.getValue("default-range", false, (Object)"") : "";
    }

    public boolean getMaskOrphan(ZoneItem zoneItem) {
        ModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
        return serviceParameters.hasDefinition("mask-orphan") ? (Boolean)serviceParameters.getValue("mask-orphan", false, (Object)false) : false;
    }

    public WebContentFilter.AccessLimitation getAccessLimitation(ZoneItem zoneItem) {
        ModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
        if (serviceParameters.hasDefinition("handle-user-access")) {
            boolean handleUserAccess = (Boolean)serviceParameters.getValue("handle-user-access", false, (Object)false);
            return handleUserAccess ? WebContentFilter.AccessLimitation.USER_ACCESS : WebContentFilter.AccessLimitation.PAGE_ACCESS;
        }
        return WebContentFilter.AccessLimitation.PAGE_ACCESS;
    }

    protected boolean getPdfDownload(ZoneItem zoneItem) {
        ModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
        return serviceParameters.hasDefinition("pdf-download") ? (Boolean)serviceParameters.getValue("pdf-download", false, (Object)false) : false;
    }

    protected boolean getIcalDownload(ZoneItem zoneItem) {
        ModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
        return serviceParameters.hasDefinition("ical-download") ? (Boolean)serviceParameters.getValue("ical-download", false, (Object)false) : false;
    }

    public Set<String> getContentTypes(ZoneItem zoneItem) {
        LinkedHashSet<String> contentTypes = new LinkedHashSet<String>();
        String[] cTypes = (String[])zoneItem.getServiceParameters().getValue("content-types", false, (Object)ArrayUtils.EMPTY_STRING_ARRAY);
        if (cTypes.length > 0 && cTypes[0].length() > 0) {
            for (String cType : cTypes) {
                if ("".equals(cType)) continue;
                contentTypes.add(cType);
            }
        }
        return contentTypes;
    }

    public Set<String> getTags(ZoneItem zoneItem, List<Map<String, Object>> searchContexts) {
        HashSet<String> hashSet = new HashSet<String>();
        if (searchContexts == null) {
            ModifiableModelAwareRepeater search = (ModifiableModelAwareRepeater)zoneItem.getServiceParameters().getValue("search");
            for (ModifiableModelAwareRepeaterEntry repeaterEntry : search.getEntries()) {
                hashSet.addAll(Arrays.asList((String[])repeaterEntry.getValue("tags", false, (Object)ArrayUtils.EMPTY_STRING_ARRAY)));
            }
        } else {
            for (Map<String, Object> entry : searchContexts) {
                hashSet.addAll(Arrays.asList((String[])entry.get("tags")));
            }
        }
        return hashSet;
    }

    public Set<Tag> getTagCategories(ZoneItem zoneItem, List<Map<String, Object>> searchContexts, String currentSiteName) {
        LinkedHashSet<Tag> categories = new LinkedHashSet<Tag>();
        List<Map<String, Object>> search = searchContexts;
        if (search == null) {
            search = new ArrayList<Map<String, Object>>();
            ModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
            HashSet<String> hashSet = new HashSet<String>();
            ModifiableModelAwareRepeater searchRepeater = (ModifiableModelAwareRepeater)serviceParameters.getValue("search");
            for (ModifiableModelAwareRepeaterEntry repeaterEntry : searchRepeater.getEntries()) {
                HashMap<String, Object> mapEntry = new HashMap<String, Object>();
                if (repeaterEntry.hasDefinition("tag-categories")) {
                    mapEntry.put("tag-categories", repeaterEntry.getValue("tag-categories", false, (Object)ArrayUtils.EMPTY_STRING_ARRAY));
                    hashSet.addAll(Arrays.asList((String[])repeaterEntry.getValue("tag-categories", false, (Object)ArrayUtils.EMPTY_STRING_ARRAY)));
                }
                if (repeaterEntry.hasValue("sites")) {
                    mapEntry.put("sites", repeaterEntry.getValue("sites", false, (Object)ArrayUtils.EMPTY_STRING_ARRAY));
                }
                search.add(mapEntry);
            }
        }
        search.forEach(searchContext -> {
            if (searchContext.containsKey("tag-categories")) {
                String[] categoriesArray = (String[])searchContext.get("tag-categories");
                for (int i = 0; i < categoriesArray.length; ++i) {
                    Map sitesData = this._jsonUtils.convertJsonToMap((String)searchContext.get("sites"));
                    List sites = (List)sitesData.get("sites");
                    String context = (String)sitesData.get("context");
                    SiteContextType siteContextType = SiteContextType.fromClientSideName((String)context);
                    HashMap<String, String> tagParameters = new HashMap<String, String>();
                    if (SiteContextType.CURRENT.equals((Object)siteContextType)) {
                        tagParameters.put("siteName", currentSiteName);
                    } else if (SiteContextType.AMONG.equals((Object)siteContextType) && sites.size() == 1) {
                        tagParameters.put("siteName", (String)sites.get(0));
                    } else {
                        tagParameters.put("siteName", null);
                    }
                    Tag category = this._tagProviderEP.getTag(categoriesArray[i], tagParameters);
                    if (category == null) continue;
                    categories.add(category);
                }
            }
        });
        return categories;
    }

    public Set<String> getAllTags(Collection<? extends Tag> tags) {
        LinkedHashSet<String> allTags = new LinkedHashSet<String>();
        for (Tag tag : tags) {
            Map childTagsMap = tag.getTags();
            if (childTagsMap == null) continue;
            Collection childTags = childTagsMap.values();
            for (Tag child : childTags) {
                allTags.add(child.getName());
            }
            allTags.addAll(this.getAllTags(childTags));
        }
        return allTags;
    }

    protected Set<Tag> getAllTags(Tag tag) {
        LinkedHashSet<Tag> allTags = new LinkedHashSet<Tag>();
        Map childTagsMap = tag.getTags();
        if (childTagsMap != null) {
            Collection childTags = childTagsMap.values();
            allTags.addAll(childTags);
            for (Tag child : childTags) {
                allTags.addAll(this.getAllTags(child));
            }
        }
        return allTags;
    }

    public DateTimeRange getDateRange(String type, int year, int month, int day, int monthsBefore, int monthsAfter, String rangeType) {
        DateTimeRange dateRange = null;
        if ("single-day".equals(type)) {
            date = this._getDate(year, month, day);
            ZonedDateTime datetime = date.atStartOfDay(ZoneId.systemDefault());
            dateRange = new DateTimeRange(datetime, datetime.plusDays(1L));
        } else if ("calendar".equals(type) || "agenda".equals(type)) {
            dateRange = this._getDateRange(monthsBefore, monthsAfter);
        } else if ("period".equals(type)) {
            date = this._getDate(year, month, day);
            dateRange = this._getDateRange(date, monthsBefore, monthsAfter);
        }
        if (this.getLogger().isInfoEnabled() && dateRange != null) {
            String start = dateRange.fromDate().format(DateTimeFormatter.ISO_LOCAL_DATE);
            String end = dateRange.untilDate().format(DateTimeFormatter.ISO_LOCAL_DATE);
            this.getLogger().info("Getting contents between " + start + " and " + end);
        }
        return dateRange;
    }

    protected DateTimeRange _getDateRange(int monthsBefore, int monthsAfter) {
        return this._getDateRange(LocalDate.now(), monthsBefore, monthsAfter);
    }

    protected DateTimeRange _getDateRange(LocalDate localDate, int monthsBefore, int monthsAfter) {
        LocalDate firstDayOfMonth = localDate.withDayOfMonth(1);
        LocalDate fromDate = firstDayOfMonth.minusMonths(monthsBefore);
        ZonedDateTime fromDateTime = fromDate.atStartOfDay(ZoneId.systemDefault());
        LocalDate untilDate = firstDayOfMonth.plusMonths(monthsAfter + 1);
        ZonedDateTime untilDateTime = untilDate.atStartOfDay(ZoneId.systemDefault());
        return new DateTimeRange(fromDateTime, untilDateTime);
    }

    protected LocalDate _getDate(int year, int month, int day) {
        LocalDate localDate = LocalDate.now();
        if (year > 0 && month > 0 && day > 0) {
            localDate.withYear(year);
            localDate.withMonth(month);
            localDate.withDayOfMonth(day);
        }
        return localDate;
    }

    public Expression getExpression(String type, DateTimeRange dateRange) {
        Expression expression = null;
        if (dateRange != null) {
            if ("single-day".equals(type)) {
                expression = this._getMetadataExpression(dateRange);
            } else if ("calendar".equals(type) || "agenda".equals(type) || "period".equals(type)) {
                expression = this._getMetadataExpression(dateRange);
            }
        }
        return expression;
    }

    protected Expression _getMetadataExpression(DateTimeRange dateRange) {
        if (dateRange != null) {
            ZonedDateTime fromDate = dateRange.fromDate();
            ZonedDateTime untilDate = dateRange.untilDate();
            DateExpression startBeforeExpr = new DateExpression(START_DATE_META, Expression.Operator.LT, untilDate);
            DateExpression endAfterExpr = new DateExpression(END_DATE_META, Expression.Operator.GE, fromDate);
            DateExpression startAfterExpr = new DateExpression(START_DATE_META, Expression.Operator.GE, fromDate);
            NotExpression noEndExpr = new NotExpression((Expression)new MetadataExpression(END_DATE_META));
            return new AndExpression(new Expression[]{startBeforeExpr, new OrExpression(new Expression[]{endAfterExpr, new AndExpression(new Expression[]{noEndExpr, startAfterExpr})})});
        }
        return null;
    }

    protected Expression _getMetadataExpression(Date date) {
        OrExpression expression = null;
        if (date != null) {
            Date nextDay = Date.from(date.toInstant().atZone(ZoneId.systemDefault()).plusDays(1L).toInstant());
            NotExpression noEndDate = new NotExpression((Expression)new MetadataExpression(END_DATE_META));
            DateExpression startDate = new DateExpression(START_DATE_META, Expression.Operator.GE, date);
            DateExpression startDateNextDay = new DateExpression(START_DATE_META, Expression.Operator.LT, nextDay);
            AndExpression onlyStartDate = new AndExpression(new Expression[]{noEndDate, startDate, startDateNextDay});
            NotExpression noStartDate = new NotExpression((Expression)new MetadataExpression(START_DATE_META));
            DateExpression endDate = new DateExpression(END_DATE_META, Expression.Operator.GE, date);
            DateExpression endDateNextDay = new DateExpression(END_DATE_META, Expression.Operator.LT, nextDay);
            AndExpression onlyEndDate = new AndExpression(new Expression[]{noStartDate, endDate, endDateNextDay});
            DateExpression afterStart = new DateExpression(START_DATE_META, Expression.Operator.LT, nextDay);
            DateExpression beforeEnd = new DateExpression(END_DATE_META, Expression.Operator.GE, date);
            AndExpression bothDates = new AndExpression(new Expression[]{afterStart, beforeEnd});
            expression = new OrExpression(new Expression[]{onlyStartDate, onlyEndDate, bothDates});
        }
        return expression;
    }

    protected int getLastDayOfWeek(Calendar cal) {
        return 1;
    }

    public Set<String> getFilteredCategories(List<Map<String, Object>> searchContexts, String[] requestedCategories, ZoneItem zoneItem, String siteName) {
        List<String> requestedTags = Arrays.asList(requestedCategories);
        Set<Tag> categoriesSet = this.getTagCategories(zoneItem, searchContexts, siteName);
        Set<String> allCategoriesNames = this.getAllTags(categoriesSet);
        Set<Object> filteredCategory = new HashSet();
        filteredCategory = requestedTags.contains("all") ? allCategoriesNames : requestedTags.stream().map(String::toUpperCase).filter(allCategoriesNames::contains).collect(Collectors.toSet());
        return filteredCategory;
    }

    public EventsFilter generateEventFilter(DateTimeRange dateRange, ZoneItem zoneItem, String view, String type, Set<String> filteredCategories, List<Map<String, Object>> searchContexts) {
        String zoneItemId = zoneItem.getId();
        Set<String> contentTypes = this.getContentTypes(zoneItem);
        boolean maskOrphan = this.getMaskOrphan(zoneItem);
        WebContentFilter.AccessLimitation accessLimitation = this.getAccessLimitation(zoneItem);
        EventsFilter eventsFilter = this.createEventsFilter(zoneItemId);
        Expression expression = this.getExpression(type, dateRange);
        this.configureFilter(eventsFilter, expression, contentTypes, searchContexts, filteredCategories, view, maskOrphan, accessLimitation);
        return eventsFilter;
    }

    public void configureFilter(EventsFilter eventsFilter, Expression expression, Collection<String> contentTypes, List<Map<String, Object>> searchContexts, Set<String> orTags, String view, boolean maskOrphan, WebContentFilter.AccessLimitation accessLimitation) {
        if (eventsFilter.getContentTypes() != null) {
            eventsFilter.getContentTypes().clear();
        }
        for (String contentType : contentTypes) {
            eventsFilter.addContentType(contentType);
        }
        eventsFilter.setMetadataExpression(expression);
        if (StringUtils.isNotEmpty((CharSequence)view)) {
            eventsFilter.setView(view);
        }
        eventsFilter.clearSearchContexts();
        this._setSearchContext(eventsFilter, searchContexts, orTags);
        eventsFilter.setMaskOrphanContents(maskOrphan);
        eventsFilter.setAccessLimitation(accessLimitation);
    }

    public List<Map<String, Object>> getSearchContext(ZoneItem zoneItem, List<Map<String, Object>> inputSearchContexts) {
        List<Map<String, Object>> searchContexts = inputSearchContexts;
        if (searchContexts == null) {
            searchContexts = new ArrayList<Map<String, Object>>();
            ModifiableModelAwareRepeater searchRepeater = (ModifiableModelAwareRepeater)zoneItem.getServiceParameters().getValue("search");
            for (ModifiableModelAwareRepeaterEntry repeaterEntry : searchRepeater.getEntries()) {
                HashMap<String, Object> mapEntry = new HashMap<String, Object>();
                if (repeaterEntry.hasDefinition("tag-categories")) {
                    mapEntry.put("tag-categories", repeaterEntry.getValue("tag-categories", false, (Object)ArrayUtils.EMPTY_STRING_ARRAY));
                }
                mapEntry.put("sites", repeaterEntry.getValue("sites", false, (Object)ArrayUtils.EMPTY_STRING_ARRAY));
                mapEntry.put("tags", repeaterEntry.getValue("tags", false, (Object)ArrayUtils.EMPTY_STRING_ARRAY));
                mapEntry.put("search-context", repeaterEntry.getValue("search-context", false, (Object)ArrayUtils.EMPTY_STRING_ARRAY));
                mapEntry.put("context-lang", repeaterEntry.getValue("context-lang", false, (Object)""));
                mapEntry.put("strict-search-on-tags", repeaterEntry.getValue("strict-search-on-tags", false, (Object)false));
                searchContexts.add(mapEntry);
            }
        }
        return searchContexts;
    }

    protected void _setSearchContext(EventsFilter filter, List<Map<String, Object>> searchContextValues, Set<String> orTags) {
        List<Map<String, Object>> nonNullSearchContextValues = Optional.ofNullable(searchContextValues).orElse(Collections.EMPTY_LIST);
        for (Map<String, Object> entry : nonNullSearchContextValues) {
            String[] tags;
            WebContentFilter.FilterSearchContext filterContext = filter.addSearchContext();
            Map sitesData = this._jsonUtils.convertJsonToMap((String)entry.get("sites"));
            String searchContext = (String)sitesData.get("context");
            Map searchContextMap = this._jsonUtils.convertJsonToMap((String)entry.get("search-context"));
            String subSearchContext = (String)searchContextMap.get("context");
            if (StringUtils.isEmpty((CharSequence)searchContext) || subSearchContext != null && !WebContentFilter.Context.CURRENT_SITE.name().equals(subSearchContext)) {
                searchContext = subSearchContext;
            }
            if ("CHILD_PAGES".equals(searchContext) || "CHILD_PAGES_OF".equals(searchContext)) {
                filterContext.setContext(WebContentFilter.Context.CHILD_PAGES);
            } else if ("DIRECT_CHILD_PAGES".equals(searchContext) || "DIRECT_CHILD_PAGES_OF".equals(searchContext)) {
                filterContext.setContext(WebContentFilter.Context.CHILD_PAGES);
                filterContext.setDepth(1);
            } else {
                filterContext.setContext(WebContentFilter.Context.valueOf((String)searchContext));
            }
            if (searchContextMap.get("page") != null) {
                filterContext.setPageId((String)searchContextMap.get("page"));
            }
            List sites = Optional.of("sites").map(sitesData::get).map(s -> (List)s).orElse(Collections.EMPTY_LIST);
            for (String site : sites) {
                filterContext.addSite(site);
            }
            String contextLang = (String)entry.get("context-lang");
            if (StringUtils.isNotEmpty((CharSequence)contextLang)) {
                filterContext.setContextLanguage(ContentFilter.ContextLanguage.valueOf((String)contextLang));
            }
            for (String tag : tags = Optional.of("tags").map(entry::get).map(t -> (String[])t).orElse(new String[0])) {
                filterContext.addTag(tag);
            }
            ((EventsFilter.EventFilterSearchContext)filterContext).setOrTags(orTags);
            if (!entry.containsKey("strict-search-on-tags")) continue;
            boolean strictSearchOnTags = (Boolean)entry.get("strict-search-on-tags");
            filterContext.setTagsAutoPosting(!strictSearchOnTags);
        }
    }

    public record DateTimeRange(ZonedDateTime fromDate, ZonedDateTime untilDate) {
    }
}

