/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */  

_migrateCalendarAndAgenda(Repository.session);
_migrateCalendarAndAgenda(Repository.liveSession);

function _migrateCalendarAndAgenda(session) 
{
    var nbSuccess = 0;
    
    var xPath = "//element(*, ametys:zoneItem)[(@ametys-internal:service='org.ametys.plugins.calendar.Agenda') or (@ametys-internal:service='org.ametys.plugins.calendar.Calendar')]"
    Repository.query(xPath, true, session).forEach( 
        zoneItem =>
        {
            if (!zoneItem.getServiceParameters().hasValue("search")) 
            {
                var searchRepeater = zoneItem.getServiceParameters().getRepeater("search", true);
                var repeaterEntry = searchRepeater.addEntry();
                
                _setRepeaterValue("tags", zoneItem, repeaterEntry);
                if (zoneItem.getServiceId() == "org.ametys.plugins.calendar.Agenda")
                {
                    _setRepeaterValue("tag-categories", zoneItem, repeaterEntry);
                }
                repeaterEntry.setValue("context-lang", "CURRENT");
                repeaterEntry.setValue("search-context", '{"context":"CURRENT_SITE","page":null}');
                repeaterEntry.setValue("sites", '{"context":"CURRENT_SITE","sites":[]}');
                zoneItem.saveChanges();
                nbSuccess++;
            }
        }
    );
    
    logger.info(nbSuccess + " calendar and agenda services have been migrated in session " + session.getWorkspace().getName());
}

function _setRepeaterValue(attributeName, zoneItem, repeaterEntry) 
{
    var propertyName = "ametys:" + attributeName;
    var parametersNode = zoneItem.getNode().getNode("ametys:service_parameters");
    
    var values = [];
    if (parametersNode.hasProperty(propertyName)) 
    {
        var property = parametersNode.getProperty(propertyName);
        values = property.getValues();
        property.remove();
    }
    
    Repository.helper.setProperty(repeaterEntry.getRepositoryData().getNode(), propertyName, values);
}

