/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.captchetat.captcha;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.ametys.plugins.captchetat.captcha.CaptchEtatHelper;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.xml.sax.SAXException;

public class CaptchetatReader
extends AbstractLogEnabled
implements Reader,
Recyclable,
Serviceable {
    protected CaptchEtatHelper _captchEtatHelper;
    private OutputStream _os;
    private CloseableHttpClient _httpClient;
    private CloseableHttpResponse _response;

    public void service(ServiceManager manager) throws ServiceException {
        this._captchEtatHelper = (CaptchEtatHelper)((Object)manager.lookup(CaptchEtatHelper.ROLE));
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(20000).setConnectionRequestTimeout(20000).setSocketTimeout(20000).build();
        this._httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).disableRedirectHandling().useSystemProperties().build();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String url = this._captchEtatHelper.getEndpoint() + "simple-captcha-endpoint?" + StringUtils.defaultString((String)request.getQueryString());
        HttpGet httpGet = new HttpGet(url);
        String token = this._captchEtatHelper.getToken();
        httpGet.addHeader("Authorization", "Bearer " + token);
        this._response = this._httpClient.execute((HttpUriRequest)httpGet);
        switch (this._response.getStatusLine().getStatusCode()) {
            case 200: {
                break;
            }
            case 403: {
                throw new IllegalStateException("CaptchEtat refused the connection");
            }
            default: {
                throw new IllegalStateException("CaptchEtat returned an error: " + IOUtils.toString((InputStream)this._response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
            }
        }
    }

    public void setOutputStream(OutputStream out) throws IOException {
        this._os = out;
    }

    public String getMimeType() {
        Header contentType = this._response.getEntity().getContentType();
        return contentType != null ? contentType.getValue() : null;
    }

    public boolean shouldSetContentLength() {
        return false;
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this._response.getEntity().writeTo(this._os);
    }

    public long getLastModified() {
        return 0L;
    }

    public void recycle() {
        try {
            this._response.close();
        }
        catch (IOException e) {
            this.getLogger().error("Can't close response", (Throwable)e);
        }
    }
}

