/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.captchetat.captcha;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

import org.ametys.core.captcha.AbstractCaptcha;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * Captcha implementation with images
 */
public class CaptchEtat extends AbstractCaptcha implements Serviceable
{
    /** The CaptchEtat helper */
    protected CaptchEtatHelper _captchEtatHelper;

    public void service(ServiceManager manager) throws ServiceException
    {
        _captchEtatHelper = (CaptchEtatHelper) manager.lookup(CaptchEtatHelper.ROLE);
    }

    @Override
    public boolean checkAndInvalidateCaptcha(String key, String value)
    {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value))
        {
            return false;
        }
        return _captchEtatHelper.checkAndInvalidateCaptcha(key, value);
    }

    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.captchetat", "PLUGINS_CAPTCHETAT_CONFIG_TYPE_CAPTCHETAT");
    }

    @Override
    public I18nizableText getLoginFailedBecauseCaptchaFailedLabel()
    {
        return new I18nizableText("plugin.captchetat", "PLUGINS_CAPTCHETAT_LOGIN_SCREEN_FORM_FAILED_WITH_CAPTCHA_CaptchEtat");
    }

    @Override
    public I18nizableText getLoginFailedBecauseTooManyAttemptLabel()
    {
        return new I18nizableText("plugin.captchetat", "PLUGINS_CAPTCHETAT_LOGIN_SCREEN_FORM_FAILED_MANY_TIME_CaptchEtat");
    }

    @Override
    public List<Pattern> getUsedUrlPatterns()
    {
        return Arrays.asList(new Pattern[] {
                Pattern.compile("^plugins/captchetat/simple-captcha-endpoint"),
                Pattern.compile("^plugins/captchetat/captcha.html"),
            });
    }
}
