<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:math="http://exslt.org/math"
                xmlns:ametys="org.ametys.core.util.AmetysXSLTHelper"
                xmlns:captcha="org.ametys.core.captcha.CaptchaHelper"
                exclude-result-prefixes="math captcha">
    <xsl:param name="width"/>
    <xsl:param name="height"/>
    
    <xsl:template match="/">
        <html>
            <head>
                <script type="text/javascript" src="{ametys:uriPrefix(false)}/plugins/captchetat/resources/js/captchetat-js-1.0.0.js"></script>
            </head>
            <body>
                <style>
                    html, body { margin: 0; padding: 0 }
                    #captchaImage { width: <xsl:value-of select="$width"/>px; height: <xsl:value-of select="$height"/>px; }
                    <!-- make each button half the height of the image by setting the size of their svg to half - 10 for the padding -->
                    <!-- we must resize the svg directly because there size are hardcoded by CaptchEtat -->
                    #logos svg {width: <xsl:value-of select="$height div 2 - 10"/>px; height: <xsl:value-of select="$height div 2 - 10"/>px; }
                </style>
                
                <input id="captchaFormulaireExtInput" type="hidden"/>
                <div id="captchetat" captchaStyleName="plugin.captchetat:PLUGINS_CAPTCHETAT_CODE" i18n:attr="captchaStyleName" urlBackend="{ametys:uriPrefix(false)}/_captchetat/plugins/captchetat/simple-captcha-endpoint"></div>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>