/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.captchetat.captcha;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.util.HttpUtils;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.captchetat.captcha.CaptchetatReader;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;

public class CaptchEtatHelper
extends AbstractLogEnabled
implements Component,
Initializable,
Serviceable {
    public static final String ROLE = CaptchEtatHelper.class.getName();
    public static final String CAPCHETAT_TOKEN_CACHE = CaptchetatReader.class.getName();
    private static final String CAPTCHA_CLIENT_ID = "captchetat.client_id";
    private static final String CAPTCHA_CLIENT_SECRET = "captchetat.client_secret";
    private static final String CAPTCHA_ENDPOINT = "captchetat.endpoint";
    private static final Map<Endpoint, String> CAPTCHA_ENDPOINT_AUTH = Map.of(Endpoint.PRODUCTION, "https://oauth.piste.gouv.fr/api/oauth/token", Endpoint.SANDBOX, "https://sandbox-oauth.piste.gouv.fr/api/oauth/token");
    private static final Map<Endpoint, String> CAPTCHA_ENDPOINT_PISTE = Map.of(Endpoint.PRODUCTION, "https://api.piste.gouv.fr/piste/captchetat/v2/", Endpoint.SANDBOX, "https://sandbox-api.piste.gouv.fr/piste/captchetat/v2/");
    protected Endpoint _endpoint;
    private AbstractCacheManager _cacheManager;
    private CloseableHttpClient _httpClient;
    private JSONUtils _jsonUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
        this._cacheManager = (AbstractCacheManager)smanager.lookup(AbstractCacheManager.ROLE);
    }

    public void initialize() {
        String endpoint;
        Config ametysConfig = Config.getInstance();
        if (ametysConfig != null && StringUtils.isNotBlank((CharSequence)(endpoint = (String)ametysConfig.getValue(CAPTCHA_ENDPOINT)))) {
            this._endpoint = Endpoint.valueOf(endpoint.toUpperCase());
            Duration duration = Duration.ofMinutes(50L);
            if (!this._cacheManager.hasCache(CAPCHETAT_TOKEN_CACHE)) {
                this._cacheManager.createMemoryCache(CAPCHETAT_TOKEN_CACHE, new I18nizableText("plugin.captchetat", "PLUGINS_CAPTCHETAT_CACHE_TOKEN_LABEL"), new I18nizableText("plugin.captchetat", "PLUGINS_CAPTCHETAT_CACHE_TOKEN_DESCRIPTION"), true, duration);
            }
            this._httpClient = HttpUtils.createHttpClient((int)0, (int)20, (boolean)false);
        }
    }

    private Cache<Pair<String, String>, String> _getCache() {
        return this._cacheManager.get(CAPCHETAT_TOKEN_CACHE);
    }

    private String _getToken(Pair<String, String> key) {
        return (String)this._getCache().get(key, this::_computeToken);
    }

    private String _computeToken(Pair<String, String> key) {
        String string;
        String url = CAPTCHA_ENDPOINT_AUTH.get((Object)this._endpoint);
        HttpPost httpPost = new HttpPost(url);
        RequestConfig config = RequestConfig.custom().setRedirectsEnabled(false).build();
        httpPost.setConfig(config);
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        pairs.add(new BasicNameValuePair("grant_type", "client_credentials"));
        pairs.add(new BasicNameValuePair("client_id", (String)key.getLeft()));
        pairs.add(new BasicNameValuePair("client_secret", (String)key.getRight()));
        pairs.add(new BasicNameValuePair("scope", "piste.captchetat"));
        UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(pairs);
        try {
            httpPost.setEntity((HttpEntity)formEntity);
            string = (String)this._httpClient.execute((ClassicHttpRequest)httpPost, response -> {
                try (HttpEntity entity = response.getEntity();){
                    String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    switch (response.getCode()) {
                        case 200: {
                            break;
                        }
                        case 403: {
                            throw new IllegalStateException("The CMS back-office refused the connection");
                        }
                        default: {
                            throw new IllegalStateException("The captchEtat token generator server returned an error " + response.getCode() + ": " + responseString);
                        }
                    }
                    Map result = this._jsonUtils.convertJsonToMap(responseString);
                    String string = (String)result.get("access_token");
                    return string;
                }
            });
        }
        catch (Throwable throwable) {
            try {
                try {
                    formEntity.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Error during request, can't compute token", e);
            }
        }
        formEntity.close();
        return string;
    }

    public String getToken() {
        return this._getToken((Pair<String, String>)Pair.of((Object)((String)Config.getInstance().getValue(CAPTCHA_CLIENT_ID)), (Object)((String)Config.getInstance().getValue(CAPTCHA_CLIENT_SECRET))));
    }

    public String getEndpoint() {
        return CAPTCHA_ENDPOINT_PISTE.get((Object)this._endpoint);
    }

    public boolean checkAndInvalidateCaptcha(String key, String value) {
        boolean bl;
        String url = this.getEndpoint() + "valider-captcha";
        HttpPost httpPost = new HttpPost(url);
        String token = this.getToken();
        httpPost.addHeader("Authorization", (Object)("Bearer " + token));
        httpPost.addHeader("accept", (Object)"application/json");
        httpPost.addHeader("Content-Type", (Object)"application/json");
        RequestConfig config = RequestConfig.custom().setRedirectsEnabled(false).build();
        httpPost.setConfig(config);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(this._getIdentifierParameterName(), key);
        parameters.put("code", value);
        String json = this._jsonUtils.convertObjectToJson(parameters);
        StringEntity jsonEntity = new StringEntity(json, ContentType.APPLICATION_JSON);
        try {
            httpPost.setEntity((HttpEntity)jsonEntity);
            bl = (Boolean)this._httpClient.execute((ClassicHttpRequest)httpPost, response -> {
                switch (response.getCode()) {
                    case 200: {
                        break;
                    }
                    case 403: {
                        throw new IllegalStateException("The CMS back-office refused the connection");
                    }
                    default: {
                        throw new IllegalStateException("The captchEtat verification server returned an error");
                    }
                }
                try (HttpEntity entity = response.getEntity();){
                    String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    Boolean bl = BooleanUtils.toBoolean((String)responseString);
                    return bl;
                }
            });
        }
        catch (Throwable throwable) {
            try {
                try {
                    jsonEntity.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.getLogger().error("Error during request, can't verify captcha", (Throwable)e);
                return false;
            }
        }
        jsonEntity.close();
        return bl;
    }

    protected String _getIdentifierParameterName() {
        return "uuid";
    }

    protected static enum Endpoint {
        PRODUCTION,
        SANDBOX;

    }
}

