/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.captchetat.captcha;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.ametys.core.util.HttpUtils;
import org.ametys.plugins.captchetat.captcha.CaptchEtatHelper;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.Reader;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.io.CloseMode;
import org.xml.sax.SAXException;

public class CaptchetatReader
extends AbstractLogEnabled
implements Reader,
Serviceable,
Initializable,
Disposable {
    protected CaptchEtatHelper _captchEtatHelper;
    private OutputStream _os;
    private CloseableHttpClient _httpClient;
    private ClassicHttpResponse _response;

    public void service(ServiceManager manager) throws ServiceException {
        this._captchEtatHelper = (CaptchEtatHelper)((Object)manager.lookup(CaptchEtatHelper.ROLE));
    }

    public void initialize() throws Exception {
        this._httpClient = HttpUtils.createHttpClient((int)0, (int)20, (boolean)false);
    }

    public void dispose() {
        this._httpClient.close(CloseMode.GRACEFUL);
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String url = this._captchEtatHelper.getEndpoint() + "simple-captcha-endpoint?" + StringUtils.defaultString((String)request.getQueryString());
        HttpGet httpGet = new HttpGet(url);
        RequestConfig config = RequestConfig.custom().setRedirectsEnabled(false).build();
        httpGet.setConfig(config);
        String token = this._captchEtatHelper.getToken();
        httpGet.addHeader("Authorization", (Object)("Bearer " + token));
        this._response = this._httpClient.executeOpen(null, (ClassicHttpRequest)httpGet, null);
        switch (this._response.getCode()) {
            case 200: {
                break;
            }
            case 403: {
                this._response.close();
                throw new IllegalStateException("CaptchEtat refused the connection");
            }
            default: {
                try {
                    try {
                        throw new IllegalStateException("CaptchEtat returned an error: " + EntityUtils.toString((HttpEntity)this._response.getEntity(), (Charset)StandardCharsets.UTF_8));
                    }
                    catch (ParseException e) {
                        throw new IllegalStateException("CaptchEtat returned an error");
                    }
                }
                catch (Throwable throwable) {
                    this._response.close();
                    throw throwable;
                }
            }
        }
    }

    public void setOutputStream(OutputStream out) throws IOException {
        this._os = out;
    }

    public String getMimeType() {
        HttpEntity entity = this._response.getEntity();
        return entity != null ? entity.getContentType() : null;
    }

    public boolean shouldSetContentLength() {
        return false;
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            this._response.getEntity().writeTo(this._os);
        }
        finally {
            this._response.close();
        }
    }

    public long getLastModified() {
        return 0L;
    }
}

