<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:math="http://exslt.org/math"
                xmlns:ametys="org.ametys.core.util.AmetysXSLTHelper"
                xmlns:captcha="org.ametys.core.captcha.CaptchaHelper"
                exclude-result-prefixes="math captcha">
        
    <xsl:template name="captcha_impl">
        <xsl:param name="key-name"/>
        <xsl:param name="key-id"/>
        <xsl:param name="color"/> <!-- not supported -->
        <xsl:param name="value-name"/>
        <xsl:param name="value-id"/>
        <xsl:param name="value-style"/>
        <xsl:param name="value-class"/>
        <xsl:param name="placeholder"/>
        <xsl:param name="placeholder-i18n"/>
        <xsl:param name="placeholder-catalogue"/>
        <xsl:param name="image-id" select="concat('id', substring-after(math:random(), '.'))"/>
        <xsl:param name="image-alt"/>
        <xsl:param name="image-alt-i18n"/>
        <xsl:param name="image-alt-catalogue"/>
        <xsl:param name="image-style"/> <!-- not supported -->
        <xsl:param name="image-class"/>
        <xsl:param name="image-width">250</xsl:param>
        <xsl:param name="image-height">75</xsl:param>
        <xsl:param name="allow-refresh"/> <!-- we cannot prevent... ignoring -->
        <xsl:param name="js-funcname-torefresh"/>
        <xsl:param name="plugin"/> <!-- not supported -->
        <xsl:param name="aria-invalid"/>
        <xsl:param name="aria-describedby"/>
        
        <xsl:variable name="id" select="substring-after(math:random(), '.')"/>
        
        <input type="text" name="{$value-name}" id="{$value-id}" style="text-transform: uppercase; {$value-style}" class="{$value-class}">
            <xsl:if test="$placeholder != ''">
                <xsl:attribute name="placeholder">
                    <xsl:if test="$placeholder-i18n and $placeholder-catalogue != ''">
                        <xsl:value-of select="$placeholder-catalogue"/>
                        <xsl:text>:</xsl:text>
                    </xsl:if>
                    <xsl:value-of select="$placeholder"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:if test="$placeholder-i18n"><xsl:attribute name="i18n:attr">placeholder</xsl:attribute></xsl:if>
            <xsl:if test="$aria-invalid = true()">
                <xsl:attribute name="aria-invalid">true</xsl:attribute>
                <xsl:if test="$aria-describedby != ''">
                    <xsl:attribute name="aria-describedby"><xsl:value-of select="$aria-describedby"/></xsl:attribute>
                </xsl:if>
            </xsl:if>
        </input>
        <input type="hidden" name="{$key-name}" id="{$key-id}"/>
        
        <!-- The div with reload/audio buttons is 47px wide -->
        <iframe src="{ametys:uriPrefix(false)}/_captchetat/plugins/captchetat/captcha.html?width={$image-width}&amp;height={$image-height}"
                id="captchetat-{$id}"
                title="plugin.captchetat:PLUGINS_CAPTCHETAT_IFRAME_TITLE" i18n:attr="title"
                style="width: {$image-width + 47}px; height: {$image-height}px"
                scrolling="no"
                frameBorder="0"
                class="{$image-class}">
            <xsl:attribute name="alt">
                <xsl:if test="$image-alt-i18n and $image-alt-catalogue != ''">
                    <xsl:value-of select="$image-alt-catalogue"/>
                    <xsl:text>:</xsl:text>
                </xsl:if>
                <xsl:value-of select="$image-alt"/>
            </xsl:attribute>
            <xsl:if test="$image-alt-i18n"><xsl:attribute name="i18n:attr">alt</xsl:attribute></xsl:if>        
        </iframe>
        <script>
            window.<xsl:value-of select="$js-funcname-torefresh"/> = function() {
                document.getElementById("captchetat-<xsl:value-of select="$id"/>").contentWindow.captchetatComponentModule.refreshCaptcha();
                document.getElementById('<xsl:value-of select="$value-id"/>').value = "";
            }
            
            document.getElementById('<xsl:value-of select="$value-id"/>').addEventListener('keyup', function() {
                document.getElementById('<xsl:value-of select="$key-id"/>').value = document.getElementById("captchetat-<xsl:value-of select="$id"/>").contentDocument.getElementById('captchetat-uuid').value;
            });
        </script>
        
    </xsl:template>

</xsl:stylesheet>
