/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the representation of a cart.
 * @private
 */
Ext.define(
	"Ametys.plugins.cart.Cart", 
	{
		config: {
			/**
			 * @cfg {String} id The unique id of the cart
			 */
			/**
			 * @method getId Get the #cfg-id
			 * @return {String} The id
			 */
			/** @ignore */
			id: null,
			/**
			 * @cfg {String} title The title of the cart
			 */
			/**
			 * @method getTitle Get the #cfg-title
			 * @return {String} The title
			 */
			/** @ignore */
			title: null,
			/**
			 * @cfg {String} description The description of the cart
			 */
			/**
			 * @method getDescription Get the #cfg-description
			 * @return {String} The description
			 */
			/** @ignore */
			description: null,
            /**
             * @cfg {String} documentation The documentation of the cart
             */
            /**
             * @method getDocumentation Get the #cfg-documentation
             * @return {String} The documentation
             */
            /** @ignore */
            documentation: null,
			/**
			 * @cfg {boolean} canRead True if the cart is in read-access for the current user
			 */
			/**
			 * @method getCanRead Get the #cfg-canRead
			 * @return {boolean} True if the cart is in read-access
			 */
			/** @ignore */
			canRead: false,
			/**
			 * @cfg {boolean} canWrite True if the cart is in write-access for the current user
			 */
            /**
             * @method getCanWrite Get the #cfg-canWrite
             * @return {boolean} True if the cart is in write-access
             */
            /** @ignore */
            canWrite: false,
            /**
             * @method getCanEditRights Get the #cfg-canAssignRights
             * @return {boolean} True if the user can edit cart rights
             */
            /** @ignore */
            canAssignRights: false,
            /**
             * @cfg {Object} author The cart owner
             */
            /**
             * @method getAuthor Get the #cfg-author
             * @return {String} The cart owner
             */
            /** @ignore */
            author: null,
            /**
             * @cfg {Object} contributor The cart last contributor
             */
            /**
             * @method getContributor Get the #cfg-contributor
             * @return {String} The cart last contributor
             */
            /** @ignore */
            contributor: null,
            /**
             * @cfg {Object} lastModificationDate The cart last modification date
             */
            /**
             * @method getLastModificationDate Get the #cfg-lastModificationDate
             * @return {String} The cart last modification date
             */
            /** @ignore */
            lastModificationDate: null,
            /**
             * @cfg {Object} creationDate The cart creation date
             */
            /**
             * @method getCreationDate Get the #cfg-creationDate
             * @return {String} The cart creation date
             */
            /** @ignore */
            creationDate: null
		},
		
		
		/**
		 * Creates a content instance
		 * @param {Object} config See configuration doc.
		 */
		constructor: function (config)
		{
			this.initConfig(config);
			
			this.messageTarget = config.messageTarget || Ametys.message.MessageTarget.CONTENT;
		},
		
		/**
		 * Get the cart's properties
		 * @return {Object} The cart's properties
		 */
		getProperties: function (initialProperty)
		{
			initialProperty = initialProperty || {};
			
			return Ext.apply ({
					id: this._id,
					title: this._title,
                    description: this._description,
                    documentation: this._documentation,
					canRead: this._canRead,
                    canWrite: this._canWrite,
                    canAssignRights: this._canAssignRights,
					author: this._author,
                    contributor: this._contributor,
                    creationDate: this._creationDate,
                    lastModificationDate: this._lastModificationDate
				}, initialProperty
			);
		},
        
        /**
         * Update the cart's properties
         * @param {Object} properties The cart's properties. Only title and description are supported
         */
        setProperties: function (properties)
        {
            this.setConfig('title', properties.title);
            this.setConfig('description', properties.description);
            this.setConfig('documentation', properties.documentation);
        }
	}
);

