/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.cart;

import java.time.ZonedDateTime;
import java.util.List;

import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * Interface representing the element of a {@link Cart}
 *
 */
public interface CartElement
{
    /**
     * Get the unique identifier of the element
     * @return The unique identifier
     */
    public String getId();
    
    /**
     * Get the element's title
     * @return The title
     */
    public I18nizableText getTitle ();
    
    /**
     * Get the element's description
     * @return The description
     */
    public I18nizableText getDescription();
    
    /**
     * Get the label of the groups
     * @return the label of the groups
     */
    public List<I18nizableText> getGroups();
    
    /**
     * Get the creation date
     * @return the creation date
     */
    public ZonedDateTime getCreationDate();
    
    /**
     * Get the author
     * @return The author
     */
    public UserIdentity getCreator();
    
    /**
     * Get the date of last modification
     * @return the date of last modification
     */
    public ZonedDateTime getLastModified();
    
    /**
     * Get the last contributor
     * @return The last contributor
     */
    public UserIdentity getLastContributor();

    /**
     * Get the type of element
     * @return The type
     */
    public String getType();
    
    /**
     * Get glyph icon. If not null, small and medium icon will be ignored
     * @return the path to small icon
     */
    public String getGlyphIcon();
    
    /**
     * Get the path to small icon (16x16 pixels)
     * @return the path to small icon
     */
    public String getSmallIcon();
    
    /**
    * Get the path to medium icon (32x32 pixels)
    * @return the path to medium icon
    */
    public String getMediumIcon();
   
}
