/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.cart.observers;

import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.cart.Cart;
import org.ametys.plugins.cart.Cart.CartElementType;
import org.ametys.plugins.explorer.ObservationConstants;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;

/**
 * Observes deletion on resources to delete resources from carts
 */
public class ResourceDeletedObserver implements Observer, Serviceable
{
    private AmetysObjectResolver _resolver;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        _resolver = (AmetysObjectResolver) smanager.lookup(AmetysObjectResolver.ROLE);
    }
    
    @Override
    public boolean supports(Event event)
    {
        return event.getId().equals(ObservationConstants.EVENT_RESOURCE_DELETED);
    }

    @Override
    public int getPriority()
    {
        return 0;
    }

    @Override
    public void observe(Event event, Map<String, Object> transientVars) throws Exception
    {
        Map<String, Object> args = event.getArguments();
        String resourceId = (String) args.get(ObservationConstants.ARGS_ID);
        
        String xPathQuery = "//element(*, ametys:cart)[@ametys:resources = '" + resourceId + "']";
        AmetysObjectIterable<Cart> carts = _resolver.query(xPathQuery);
        
        for (Cart cart : carts)
        {
            cart.removeElement(resourceId, CartElementType.RESOURCE);
            cart.saveChanges();
        }
    }

}
