/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.cart;

import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.cart.CartElement;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.runtime.i18n.I18nizableText;

public class ResourceElement
implements CartElement {
    private Resource _resource;

    public ResourceElement(Resource resource) {
        this._resource = resource;
    }

    @Override
    public String getId() {
        return this._resource.getId();
    }

    @Override
    public I18nizableText getTitle() {
        return new I18nizableText(this._resource.getName());
    }

    @Override
    public I18nizableText getDescription() {
        return new I18nizableText("");
    }

    @Override
    public List<I18nizableText> getGroups() {
        return Collections.singletonList(new I18nizableText("plugin.cart", "PLUGINS_CART_UITOOL_CART_RESOURCES_GROUP"));
    }

    @Override
    public ZonedDateTime getCreationDate() {
        return DateUtils.asZonedDateTime((Date)this._resource.getCreationDate());
    }

    @Override
    public UserIdentity getCreator() {
        return this._resource.getCreator();
    }

    @Override
    public ZonedDateTime getLastModified() {
        return DateUtils.asZonedDateTime((Date)this._resource.getLastModified());
    }

    @Override
    public UserIdentity getLastContributor() {
        return this._resource.getLastContributor();
    }

    @Override
    public String getType() {
        return "resource";
    }

    @Override
    public String getGlyphIcon() {
        String extension;
        int index = this._resource.getName().lastIndexOf(".");
        switch (extension = this._resource.getName().substring(index + 1)) {
            case "css": {
                return "ametysicon-css5";
            }
            case "csv": {
                return "ametysicon-file-extension-csv";
            }
            case "doc": {
                return "ametysicon-file-extension-doc";
            }
            case "docx": {
                return "ametysicon-file-extension-docx";
            }
            case "html": 
            case "htm": 
            case "xhtml": {
                return "ametysicon-file-extension-html";
            }
            case "png": 
            case "jpg": 
            case "jpeg": 
            case "bmp": 
            case "gif": {
                return "ametysicon-image2";
            }
            case "pdf": {
                return "ametysicon-pdf17";
            }
            case "ppt": {
                return "ametysicon-ppt";
            }
            case "pptx": {
                return "ametysicon-pptx";
            }
            case "txt": {
                return "ametysicon-txt";
            }
            case "avi": 
            case "mov": 
            case "swf": 
            case "wmv": 
            case "flv": 
            case "mpeg": 
            case "mpg": {
                return "ametysicon-movie16";
            }
            case "xml": {
                return "ametysicon-xml6";
            }
            case "xls": {
                return "ametysicon-xls1";
            }
            case "xlsx": {
                return "ametysicon-xlsx";
            }
            case "zip": {
                return "ametysicon-zip6";
            }
            case "rar": 
            case "odp": {
                return "ametysicon-odp2";
            }
            case "odt": {
                return "ametysicon-odt5";
            }
            case "jar": {
                return "ametysicon-jar3";
            }
            case "pps": {
                return "ametysicon-pps2";
            }
            case "psd": {
                return "ametysicon-psd3";
            }
            case "tar": 
            case "tgz": {
                return "ametysicon-tar1";
            }
            case "mp3": 
            case "mod": 
            case "mid": {
                return "ametysicon-music168";
            }
        }
        return "ametysicon-question-mark1";
    }

    @Override
    public String getSmallIcon() {
        return null;
    }

    @Override
    public String getMediumIcon() {
        return null;
    }

    public Resource getResource() {
        return this._resource;
    }
}

