/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */


/**
 * This class is the data model for cart entries.
 * @private
 */
Ext.define('Ametys.plugins.cart.tool.CartTool.CartElementEntry', {
	extend: 'Ext.data.Model',
	
	fields: [
	    'elmtId',    
		{name: 'title', type: 'string'},
		{name: 'description', type: 'string'},
		'group',
		
        'creator',
        'creation',
        'lastModification',
        'lastContributor',

        'type',
        'queryType', // for query only
        'documentation', // for query only
        
        'iconGlyph',
		{name: 'icon', mapping: 'smallIcon'},
        'smallIcon',
        'mediumIcon',
        'largeIcon',
        
        {
        	name: 'workflowStep', 
        	mapping: function(data) {
        		if (data['workflow-step'])
        		{
        			return data['workflow-step'].name;
        		}
        		else
        		{
        			return "";
        		}
        	}
        },
        {
        	name: 'workflowStepId', 
        	mapping: function(data) {
        		if (data['workflow-step'])
        		{
	        		return data['workflow-step'].id;
        		}
        		else
        		{
        			return null;
        		}
        	}
        },
        {
        	name: 'workflowStepIcon', 
        	mapping: function(data) {
        		if (data['workflow-step'])
        		{
	        		return data['workflow-step']['icon-small'];
        		}
        		else
        		{
        			return null;
        		}
        	}
        }
	]
});
