/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.cart;

import java.util.Collections;
import java.util.List;

import org.ametys.plugins.queriesdirectory.Query;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * Implementation of a {@link CartElement} wrapping a query from directory
 */
public class QueryFromDirectoryElement extends QueryElement
{
    private Query _query;
    
    /**
     * Constructor
     * @param query the query
     */
    public QueryFromDirectoryElement (Query query)
    {
        super(query.getId(), query.getContent(), query.getAuthor(), query.getCreationDate(), query.getContributor(), query.getLastModificationDate(), query.getTitle());
        _query = query;
    }
    
    @Override
    public String getType()
    {
        return "cartQueryFromDirectory";
    }
    
    @Override
    public List<I18nizableText> getGroups()
    {
        return Collections.singletonList(new I18nizableText("plugin.cart", "PLUGINS_CART_UITOOL_CART_QUERIES_FROM_DIRECTORY_GROUP"));
    }
    
    @Override
    public String getGlyphIcon()
    {
        String type = _query.getType();
        switch (type)
        {
            case "solr":
                return "ametysicon-solr";
            case "script":
                return "ametysicon-development";
            case "formatting":
                return "ametysicon-paintbrush";
            case "simple":
            case "advanced":
                return "ametysicon-magnifier41";
            default:
                return super.getGlyphIcon();
        }
    }
    
    /**
     * Get the query from id
     * @return the query
     */
    public Query getQuery()
    {
        return _query;
    }
    
    @Override
    public I18nizableText getDescription()
    {
        return new I18nizableText(_query.getDescription());
    }
    
    @Override
    public String getQueryContent()
    {
        return _query.getContent();
    }
}
