/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

// Update existing carts to fill last contributor, creation and last modification date

let now = java.time.ZonedDateTime.now();

let carts = Repository.query("//element(*, ametys:cart)");
let handledCarts = 0;
let totalCarts = carts.getSize();

carts.forEach(
    cart =>
    {
        logger.info(`Updating cart '${cart.getTitle()}' (${cart.getId()})`);
        
        if (cart.getCreationDate() == null)
        {
            cart.setCreationDate(now);
        }
        if (cart.getLastModificationDate() == null)
        {
            cart.setLastModificationDate(now);
        }
        if (cart.getContributor() == null)
        {
            cart.setContributor(cart.getAuthor());
        }
        
        cart.saveChanges();
        
        handledCarts++;
        if (handledCarts % 20 == 0)
        {
            logger.info(`[${handledCarts}/${totalCarts}] handled carts`);
        }
    }
);

logger.info(`${handledCarts} handled carts`);