/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.cart.actions;

import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.core.util.URIUtils;
import org.ametys.plugins.cart.Cart;
import org.ametys.plugins.repository.AmetysObjectResolver;

/**
 * This action adds HTTP headers to the response to export the cart
 */
public class CartExportSetFilenameHeader extends ServiceableAction
{
    private AmetysObjectResolver _resolver;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);        
        _resolver = (AmetysObjectResolver) smanager.lookup(AmetysObjectResolver.ROLE);
    }
    
    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        
        String id = request.getParameter("cartId");
        Cart cart = _resolver.resolveById(id);
        
        String fileExtension = parameters.getParameter("fileExtension");
        
        String filename = cart.getTitle() + "." + fileExtension;
        
        Response response = ObjectModelHelper.getResponse(objectModel);
        
        String encodedName = URIUtils.encodeHeader(filename);
        response.setHeader("Content-Disposition", "attachment; filename=\"" + encodedName + "\";filename*=utf-8''" + encodedName);
        
        return EMPTY_MAP;
    }
}
