/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

Ext.define('Ametys.plugins.cart.CartTargetToContextConvertor', {
    extend: 'Ametys.plugins.coreui.rights.AbstractTargetToContextConvertor',
    
    isSupportedTarget: function(target)
    {
        return target != null && target.getId() == Ametys.message.MessageTarget.CART;
    },
    
    convert: function(target)
    {
        return target.getParameters().id;
    },
    
    getContextInfo:function(target)
    {
        return {label: target.getParameters().title, type: '{{i18n PLUGINS_CART_CONTEXT_CONVERTOR_CART_TYPE_LABEL}}'};
    }
});

