/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.cart.actions;

import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.spi.Step;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.cart.Cart;
import org.ametys.plugins.cart.CartElement;
import org.ametys.plugins.cart.CartsDAO;
import org.ametys.plugins.cart.ContentElement;
import org.ametys.plugins.cart.QueryElement;
import org.ametys.plugins.cart.QueryFromDirectoryElement;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.queriesdirectory.QueryDAO;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.version.VersionAwareAmetysObject;
import org.ametys.plugins.workflow.repository.WorkflowAwareAmetysObject;
import org.ametys.plugins.workflow.store.AmetysStep;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.ArrayUtils;

public class GetCartElementsAction
extends ServiceableAction {
    protected AmetysObjectResolver _resolver;
    protected WorkflowProvider _workflowProvider;
    protected WorkflowHelper _workflowHelper;
    protected CurrentUserProvider _userProvider;
    protected UserManager _userManager;
    protected UserHelper _userHelper;
    protected CartsDAO _cartsDAO;
    protected QueryDAO _queryDAO;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._workflowProvider = (WorkflowProvider)serviceManager.lookup(WorkflowProvider.ROLE);
        this._workflowHelper = (WorkflowHelper)serviceManager.lookup(WorkflowHelper.ROLE);
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
        this._userProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._userHelper = (UserHelper)serviceManager.lookup(UserHelper.ROLE);
        this._cartsDAO = (CartsDAO)serviceManager.lookup(CartsDAO.ROLE);
        this._queryDAO = (QueryDAO)serviceManager.lookup(QueryDAO.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Map jsParameters = (Map)objectModel.get("parent-context");
        String id = (String)jsParameters.get("cartId");
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        int total = 0;
        try {
            Cart cart = (Cart)this._resolver.resolveById(id);
            UserIdentity user = this._userProvider.getUser();
            if (this._cartsDAO.canRead(user, cart)) {
                result.put("label", cart.getTitle());
                result.put("description", cart.getDescription());
                List<CartElement> elements = cart.getElements();
                for (CartElement elmt : elements) {
                    boolean isQueryFromDirectory = elmt instanceof QueryFromDirectoryElement;
                    if (isQueryFromDirectory && !this._queryDAO.canRead(user, ((QueryFromDirectoryElement)elmt).getQuery())) continue;
                    nodes.addAll(this.elementToJSON(elmt));
                }
                total = elements.size();
            }
            result.put("cartElements", nodes);
            result.put("total", total);
        }
        catch (UnknownAmetysObjectException e) {
            result.put("unknown-cart", true);
        }
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    protected List<Map<String, Object>> elementToJSON(CartElement elmt) {
        ArrayList<Map<String, Object>> elmts = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("elmtId", elmt.getId());
        infos.put("title", elmt.getTitle());
        infos.put("description", elmt.getDescription());
        infos.put("creation", DateUtils.zonedDateTimeToString((ZonedDateTime)elmt.getCreationDate()));
        infos.put("creator", this._userHelper.user2json(elmt.getCreator(), true));
        infos.put("lastModification", DateUtils.zonedDateTimeToString((ZonedDateTime)elmt.getLastModified()));
        infos.put("lastContributor", this._userHelper.user2json(elmt.getLastContributor(), true));
        infos.put("iconGlyph", elmt.getGlyphIcon());
        infos.put("smallIcon", elmt.getSmallIcon());
        infos.put("mediumIcon", elmt.getMediumIcon());
        infos.put("type", elmt.getType());
        if (elmt instanceof ContentElement) {
            Content content = (Content)this._resolver.resolveById(elmt.getId());
            infos.put("workflow-step", this.workflowStepToJSON(content));
        } else if (elmt instanceof QueryElement) {
            QueryElement queryElmt = (QueryElement)elmt;
            infos.put("queryContent", queryElmt.getQueryContent());
            if (queryElmt instanceof QueryFromDirectoryElement) {
                QueryFromDirectoryElement queryDirectoryElmt = (QueryFromDirectoryElement)queryElmt;
                infos.put("documentation", queryDirectoryElmt.getQuery().getDocumentation());
                infos.put("queryType", queryDirectoryElmt.getQuery().getType());
            }
        }
        List<I18nizableText> groups = elmt.getGroups();
        for (I18nizableText group : groups) {
            HashMap clonedInfos = (HashMap)infos.clone();
            clonedInfos.put("group", group);
            elmts.add(clonedInfos);
        }
        return elmts;
    }

    protected Map<String, Object> workflowStepToJSON(Content content) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        if (content instanceof WorkflowAwareContent) {
            WorkflowAwareContent waContent = (WorkflowAwareContent)content;
            try {
                WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow((WorkflowAwareAmetysObject)waContent);
                long workflowId = waContent.getWorkflowId();
                String workflowName = workflow.getWorkflowName(workflowId);
                Step currentStep = this._getCurrentStep(waContent, workflow);
                int currentStepId = currentStep.getStepId();
                I18nizableText workflowStepName = new I18nizableText("application", this._workflowHelper.getStepName(workflowName, currentStepId));
                infos.put("id", String.valueOf(currentStepId));
                infos.put("name", workflowStepName);
                if ("application".equals(workflowStepName.getCatalogue())) {
                    infos.put("icon-small", "/plugins/cms/resources_workflow/" + workflowStepName.getKey() + "-small.png");
                    infos.put("icon-medium", "/plugins/cms/resources_workflow/" + workflowStepName.getKey() + "-medium.png");
                    infos.put("icon-large", "/plugins/cms/resources_workflow/" + workflowStepName.getKey() + "-large.png");
                } else {
                    String pluginName = workflowStepName.getCatalogue().substring("plugin.".length());
                    infos.put("icon-small", "/plugins/" + pluginName + "/resources/img/workflow/" + workflowStepName.getKey() + "-small.png");
                    infos.put("icon-medium", "/plugins/" + pluginName + "/resources/img/workflow/" + workflowStepName.getKey() + "-medium.png");
                    infos.put("icon-large", "/plugins/" + pluginName + "/resources/img/workflow/" + workflowStepName.getKey() + "-large.png");
                }
            }
            catch (AmetysRepositoryException ametysRepositoryException) {
            }
            catch (WorkflowException workflowException) {
                // empty catch block
            }
        }
        return infos;
    }

    protected Step _getCurrentStep(WorkflowAwareContent content, WorkflowProvider.AmetysObjectWorkflow workflow) throws WorkflowException {
        Object[] allRevisions;
        int currentRevIndex;
        VersionAwareAmetysObject vaContent;
        String currentRevision;
        long workflowId = content.getWorkflowId();
        Step currentStep = (Step)workflow.getCurrentSteps(workflowId).get(0);
        if (content instanceof VersionAwareAmetysObject && (currentRevision = (vaContent = (VersionAwareAmetysObject)content).getRevision()) != null && (currentRevIndex = ArrayUtils.indexOf((Object[])(allRevisions = vaContent.getAllRevisions()), (Object)currentRevision)) > -1 && currentRevIndex < allRevisions.length - 1) {
            AmetysStep amStep;
            Date nextRevTimestamp;
            Object nextRevision = allRevisions[currentRevIndex + 1];
            Date currentRevTimestamp = vaContent.getRevisionTimestamp();
            List steps = this._workflowHelper.getStepsBetween((Workflow)workflow, workflowId, currentRevTimestamp, nextRevTimestamp = vaContent.getRevisionTimestamp((String)nextRevision));
            if (steps.size() > 0 && steps.get(0) instanceof AmetysStep && (amStep = (AmetysStep)steps.get(0)).getProperty("actionFinishDate") != null) {
                steps = steps.subList(1, steps.size());
            }
            Collections.sort(steps, new Comparator<Step>(this){

                @Override
                public int compare(Step step1, Step step2) {
                    return -Long.valueOf(step1.getId()).compareTo(step2.getId());
                }
            });
            if (steps.size() > 0) {
                currentStep = (Step)steps.get(0);
            }
        }
        return currentStep;
    }
}

