<?xml version="1.0"?>
<!--
   Copyright 2013 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

	<xsl:import href="plugin:cms://stylesheets/helper/html-hierarchy.xsl"/>
	<xsl:import href="cart2html.xsl"/>
	
	<xsl:template match="cart">
		<html>
	  		<head>
	  			<title><xsl:value-of select="label"/></title>
	  			<link rel="stylesheet" type="text/css" href="{$contextPath}/plugins/cart/resources/css/print.css"/>
	  		</head>
	  		<body onload="window.print()">
	  			
	  			<xsl:if test="queries/query">
	  				<h1><xsl:value-of select="queries/query[1]/group"/></h1>
	  				<xsl:apply-templates select="queries/query"/>  
	  			</xsl:if>
	  			
	  			<xsl:if test="resources/resource">
	  				<h1><xsl:value-of select="resources/resource[1]/group"/></h1>
	  				
	  				<xsl:call-template name="table">
						<xsl:with-param name="elements" select="resources/resource"/>
					</xsl:call-template>
		
	  			</xsl:if>
	  			
	  			<xsl:if test="contents/content">
	  				<xsl:apply-templates select="contents"/>  
	  			</xsl:if>
	  			
	  		</body>
	  	</html>
	</xsl:template>
	
	<xsl:template match="contents">
		<xsl:for-each select="content[not(group = preceding-sibling::content/group)]">
			<xsl:variable name="group" select="group"/>
			
			<h1>Objets: <xsl:value-of select="group"/></h1>
			
			<xsl:apply-templates select="../content[group = $group]">
				<xsl:sort select="title"/>
			</xsl:apply-templates>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template match="content">
		<xsl:apply-templates select="html/body/node()" mode="move-hierarchy">
			<xsl:with-param name="level" select="2"/>
		</xsl:apply-templates>
	</xsl:template>
	  
	<xsl:template match="query">
  		<h2><xsl:value-of select="title"/></h2>
  		
        <xsl:copy-of select="html/body/table"/>
  		<!-- <xsl:call-template name="table">
			<xsl:with-param name="elements" select="contents/content"/>
		</xsl:call-template> -->
					
  	</xsl:template>
  	
</xsl:stylesheet>
