/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.archive;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.ametys.plugins.contentio.archive.Archiver;
import org.ametys.plugins.contentio.archive.ContentsArchiverHelper;
import org.ametys.plugins.contentio.archive.ImportReport;
import org.ametys.plugins.contentio.archive.ManifestReaderWriter;
import org.ametys.plugins.contentio.archive.Merger;
import org.ametys.plugins.contentio.archive.PartialImport;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.repository.collection.AmetysObjectCollection;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.slf4j.Logger;

public class ContentArchiver
extends AbstractLogEnabled
implements Archiver,
Serviceable {
    public static final String ID = "contents";
    private AmetysObjectResolver _resolver;
    private ContentsArchiverHelper _contentsArchiverHelper;
    private ManifestReaderWriter _manifestReaderWriter = new ContentArchiverManifestReaderWriter(this.getLogger());

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._contentsArchiverHelper = (ContentsArchiverHelper)((Object)manager.lookup(ContentsArchiverHelper.ROLE));
    }

    @Override
    public ManifestReaderWriter getManifestReaderWriter() {
        return this._manifestReaderWriter;
    }

    @Override
    public void export(ZipOutputStream zos) throws IOException {
        AmetysObjectCollection rootContents = this._rootContents();
        this._contentsArchiverHelper.exportContents("contents/", (TraversableAmetysObject)rootContents, zos);
    }

    private AmetysObjectCollection _rootContents() {
        return (AmetysObjectCollection)this._resolver.resolveByPath("/ametys:contents");
    }

    private void _deleteBeforePartialImport(AmetysObjectCollection rootContents) throws IOException {
        try {
            Node rootContentsNode = rootContents.getNode();
            NodeIterator rootChildren = rootContentsNode.getNodes();
            while (rootChildren.hasNext()) {
                rootChildren.nextNode().remove();
            }
            rootContentsNode.getSession().save();
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Collection<String> managedPartialImports(Collection<String> partialImports) {
        return partialImports.contains(ID) ? Collections.singletonList(ID) : Collections.EMPTY_LIST;
    }

    @Override
    public ImportReport partialImport(Path zipPath, Collection<String> partialImports, Merger merger, boolean deleteBefore) throws IOException {
        AmetysObjectCollection rootContents = this._rootContents();
        if (deleteBefore) {
            this._deleteBeforePartialImport(rootContents);
        }
        return this._contentsArchiverHelper.importContents("contents/", rootContents, zipPath, merger, Collections.EMPTY_SET);
    }

    private static final class ContentArchiverManifestReaderWriter
    implements ManifestReaderWriter {
        private static final String __DATA = "contents";
        private Logger _logger;

        public ContentArchiverManifestReaderWriter(Logger logger) {
            this._logger = logger;
        }

        @Override
        public Object getData() {
            return "contents";
        }

        @Override
        public Stream<PartialImport> toPartialImports(Object data) {
            return Optional.ofNullable(data).filter(String.class::isInstance).map(String.class::cast).filter("contents"::equals).map(Stream::of).orElseGet(() -> {
                this._logger.warn("Unexpected manifest data '{}', we would expect '{}', the ZIP archive probably comes from a different version of Ametys.", data, (Object)"contents");
                return Stream.empty();
            }).map(contentsStr -> PartialImport.of(contentsStr, new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_ARCHIVE_IMPORT_CONTENT_ARCHIVER_OPTION_ALL")));
        }
    }
}

