/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.archive;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.xml.transform.TransformerException;
import org.ametys.core.util.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class DomNodeHelper {
    private DomNodeHelper() {
    }

    static String nullableStringValue(Node node, String xpath) throws TransformerException {
        return DomNodeHelper._nonEmptyValue(node, xpath).orElse(null);
    }

    private static Optional<String> _nonEmptyValue(Node node, String xpath) throws TransformerException {
        XObject xObject = XPathAPI.eval((Node)node, (String)xpath);
        return Optional.of(xObject).filter(o -> -1 != o.getType()).map(XObject::str).filter(StringUtils::isNotBlank);
    }

    static Date nullableDateValue(Node node, String xpath) throws TransformerException {
        return DomNodeHelper._nonEmptyValue(node, xpath).map(dateStr -> DateTimeFormatter.ISO_LOCAL_DATE.parse((CharSequence)dateStr, LocalDate::from)).map(DateUtils::asDate).orElse(null);
    }

    static Date nullableDatetimeValue(Node node, String xpath) throws TransformerException {
        return DomNodeHelper._nonEmptyValue(node, xpath).map(dateStr -> DateUtils.getISODateTimeFormatter().parse((CharSequence)dateStr, ZonedDateTime::from)).map(DateUtils::asDate).orElse(null);
    }

    static String[] stringValues(Node node, String xpath) throws TransformerException {
        NodeList nodeList = XPathAPI.selectNodeList((Node)node, (String)xpath);
        return (String[])IntStream.range(0, nodeList.getLength()).mapToObj(nodeList::item).map(Node::getTextContent).toArray(String[]::new);
    }
}

