/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.archive;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.schedule.Runnable;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.contentio.archive.ImportArchiveSchedulable;
import org.ametys.plugins.contentio.archive.MergePolicy;
import org.ametys.runtime.i18n.I18nizableText;

public class ImportArchiveRunnable
implements Runnable {
    private static final String __ID_PREFIX = ImportArchiveRunnable.class.getName();
    private String _id;
    private String _archiveName;
    private Optional<Collection<String>> _elements;
    private MergePolicy _mergePolicy;
    private UserIdentity _userIdentity;

    public ImportArchiveRunnable(String archiveName, Optional<Collection<String>> elements, MergePolicy mergePolicy, UserIdentity user) {
        this._setId();
        this._archiveName = archiveName;
        this._elements = elements;
        this._mergePolicy = mergePolicy;
        this._userIdentity = user;
    }

    private void _setId() {
        this._id = __ID_PREFIX + "$" + System.currentTimeMillis();
    }

    public String getId() {
        return this._id;
    }

    public I18nizableText getLabel() {
        return new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_ARCHIVE_IMPORT_RUNNABLE_LABEL");
    }

    public I18nizableText getDescription() {
        return new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_ARCHIVE_IMPORT_RUNNABLE_DESC");
    }

    public Runnable.FireProcess getFireProcess() {
        return Runnable.FireProcess.NOW;
    }

    public String getCronExpression() {
        return null;
    }

    public String getSchedulableId() {
        return ImportArchiveSchedulable.ID;
    }

    public boolean isRemovable() {
        return false;
    }

    public boolean isModifiable() {
        return false;
    }

    public boolean isDeactivatable() {
        return false;
    }

    public Runnable.MisfirePolicy getMisfirePolicy() {
        return null;
    }

    public boolean isVolatile() {
        return false;
    }

    public Map<String, Object> getParameterValues() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("archive", this._archiveName);
        values.put("mergePolicy", (Object)this._mergePolicy);
        this._elements.ifPresent(els -> values.put("elements", els));
        return values;
    }

    public UserIdentity getUserIdentity() {
        return this._userIdentity;
    }
}

