/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.archive;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;

public final class ZipEntryHelper {
    private ZipEntryHelper() {
    }

    private static FileSystem _zipFileSystem(Path zipArchivePath) throws IOException {
        return FileSystems.newFileSystem(zipArchivePath, ClassLoader.getSystemClassLoader());
    }

    public static Path zipFileRoot(Path zipArchivePath) throws IOException {
        FileSystem zipFileSystem = ZipEntryHelper._zipFileSystem(zipArchivePath);
        Path[] roots = (Path[])StreamSupport.stream(zipFileSystem.getRootDirectories().spliterator(), false).toArray(Path[]::new);
        if (roots.length != 1) {
            throw new IllegalStateException(String.format("Unexpected error, the zip file '%s' should have 1 and only 1 root directory", zipArchivePath));
        }
        Path zipFileRoot = roots[0];
        return zipFileRoot;
    }

    public static Stream<Path> zipFileTree(Path zipArchivePath, Optional<String> startingPath, BiPredicate<Path, BasicFileAttributes> filter) throws IOException {
        return ZipEntryHelper._zipFileTree(zipArchivePath, startingPath, Integer.MAX_VALUE, filter);
    }

    private static Stream<Path> _zipFileTree(Path zipArchivePath, Optional<String> startingPath, int maxDepth, BiPredicate<Path, BasicFileAttributes> filter) throws IOException {
        Path zipFileRoot = ZipEntryHelper.zipFileRoot(zipArchivePath);
        Path start = startingPath.map(zipFileRoot::resolve).orElse(zipFileRoot);
        return Files.find(start, maxDepth, filter, new FileVisitOption[0]);
    }

    public static DirectoryStream<Path> children(Path zipArchivePath, Optional<String> startingPath, DirectoryStream.Filter<? super Path> filter) throws IOException {
        Path zipFileRoot = ZipEntryHelper.zipFileRoot(zipArchivePath);
        Path start = startingPath.map(zipFileRoot::resolve).orElse(zipFileRoot);
        return Files.newDirectoryStream(start, filter);
    }

    public static boolean zipEntryFolderExists(Path zipPath, String zipEntryFolderPath) throws IOException {
        Path zipEntryPath = ZipEntryHelper._zipFileSystem(zipPath).getPath(zipEntryFolderPath, new String[0]);
        return Files.exists(zipEntryPath, new LinkOption[0]) && Files.isDirectory(zipEntryPath, new LinkOption[0]);
    }

    public static boolean zipEntryFileExists(Path zipPath, String zipEntryFilePath) throws IOException {
        Path zipEntryPath = ZipEntryHelper._zipFileSystem(zipPath).getPath(zipEntryFilePath, new String[0]);
        return Files.exists(zipEntryPath, new LinkOption[0]) && Files.isRegularFile(zipEntryPath, new LinkOption[0]);
    }

    public static InputStream zipEntryFileInputStream(Path zipPath, String zipEntryFilePath) throws IOException {
        String name;
        final ZipFile zipFile = new ZipFile(zipPath.toFile());
        ZipEntry zipEntry = zipFile.getEntry(name = StringUtils.stripStart((String)zipEntryFilePath, (String)"/"));
        if (zipEntry == null) {
            throw new IOException(String.format("Wrong zip entry file path '%s', it cannot be found in the archive '%s'", zipEntryFilePath, zipPath));
        }
        InputStream manifestIs = zipFile.getInputStream(zipEntry);
        return new FilterInputStream(manifestIs){

            @Override
            public void close() throws IOException {
                super.close();
                zipFile.close();
            }
        };
    }
}

