/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.csv;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.contentio.csv.ImportCSVFileHelper;
import org.ametys.plugins.contentio.csv.SynchronizeModeEnumerator;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.cocoon.servlet.multipart.PartOnDisk;
import org.apache.cocoon.servlet.multipart.RejectedPart;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.supercsv.prefs.CsvPreference;

public class ImportCSVFile
implements Serviceable,
Contextualizable,
Component {
    public static final String ROLE = ImportCSVFile.class.getName();
    static final String CONTENTIO_STORAGE_DIRECTORY = "contentio/temp";
    private static final String[] _ALLOWED_EXTENSIONS = new String[]{"txt", "csv"};
    private ContentTypeExtensionPoint _contentTypeEP;
    private WorkflowHelper _workflowHelper;
    private ImportCSVFileHelper _importCSVFileHelper;
    private Enumerator _synchronizeModeEnumerator;
    private Context _context;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._contentTypeEP = (ContentTypeExtensionPoint)serviceManager.lookup(ContentTypeExtensionPoint.ROLE);
        this._workflowHelper = (WorkflowHelper)serviceManager.lookup(WorkflowHelper.ROLE);
        this._importCSVFileHelper = (ImportCSVFileHelper)((Object)serviceManager.lookup(ImportCSVFileHelper.ROLE));
        this._synchronizeModeEnumerator = (Enumerator)serviceManager.lookup(SynchronizeModeEnumerator.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Callable(rights={"Plugins_ContentIO_ImportFile"}, context="/cms")
    public Map importCSVFile(String escapingChar, String separatingChar, String contentTypeId, Part part) throws Exception {
        Request request = ContextHelper.getRequest((Context)this._context);
        HashMap<String, Object> result = new HashMap<String, Object>();
        ContentType contentType = (ContentType)this._contentTypeEP.getExtension(contentTypeId);
        if (part instanceof RejectedPart || part == null) {
            result.put("success", false);
            result.put("error", "rejected");
        } else {
            PartOnDisk uploadedFilePart = (PartOnDisk)part;
            File uploadedFile = uploadedFilePart.getFile();
            String filename = uploadedFilePart.getFileName().toLowerCase();
            if (!FilenameUtils.isExtension((String)filename, (String[])_ALLOWED_EXTENSIONS)) {
                result.put("error", "invalid-extension");
                request.setAttribute(JSonReader.OBJECT_TO_READ, result);
                return result;
            }
            try (FileInputStream fileInputStream = new FileInputStream(uploadedFile);
                 BufferedInputStream inputStream = IOUtils.buffer((InputStream)fileInputStream);){
                Charset charset = this._importCSVFileHelper.detectCharset(inputStream);
                result.put("charset", charset);
                String[] headers = this._importCSVFileHelper.extractHeaders(inputStream, this._getCSVPreference(escapingChar, separatingChar), charset);
                if (headers == null) {
                    result.put("error", "no-header");
                    request.setAttribute(JSonReader.OBJECT_TO_READ, result);
                    HashMap<String, Object> hashMap = result;
                    return hashMap;
                }
                List<Map<String, Object>> mapping = this._importCSVFileHelper.getMapping(contentType, headers);
                result.put("mapping", mapping);
                Map attributeCount = mapping.stream().map(map -> map.get("attributePath")).map(String.class::cast).filter(StringUtils::isNotEmpty).map(attributePath -> {
                    String attributePrefix = "";
                    int endIndex = attributePath.lastIndexOf("/");
                    if (endIndex != -1) {
                        attributePrefix = attributePath.substring(0, endIndex);
                    }
                    return attributePrefix;
                }).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
                for (Map<String, Object> map2 : mapping) {
                    boolean parentIsContent;
                    String attributePath2 = (String)map2.get("attributePath");
                    String attributePrefix = "";
                    int endIndex = attributePath2.lastIndexOf("/");
                    if (endIndex != -1) {
                        attributePrefix = attributePath2.substring(0, endIndex);
                    }
                    if (attributePrefix.equals("")) {
                        parentIsContent = true;
                    } else if (contentType.hasModelItem(attributePrefix)) {
                        ModelItem modelItem = contentType.getModelItem(attributePrefix);
                        String modelTypeId = modelItem.getType().getId();
                        parentIsContent = "content".equals(modelTypeId);
                    } else {
                        parentIsContent = false;
                    }
                    if (!attributeCount.getOrDefault(attributePrefix, 0L).equals(1L) || !parentIsContent || !StringUtils.isNotBlank((CharSequence)attributePath2)) continue;
                    map2.put("isId", true);
                }
                String importId = UUID.randomUUID().toString();
                this._copyFile(uploadedFile.toPath(), importId);
                result.put("importId", importId);
                result.put("success", true);
                result.put("workflows", this._getWorkflows());
                result.put("defaultWorkflow", contentType.getDefaultWorkflowName().orElse(null));
                result.put("fileName", uploadedFile.getName());
                List<Map> synchronizeModes = this._synchronizeModeEnumerator.getEntries().entrySet().stream().map(entry -> Map.of("value", entry.getKey(), "label", entry.getValue())).toList();
                result.put("synchronizeModes", synchronizeModes);
            }
        }
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return result;
    }

    private void _copyFile(Path path, String importId) throws IOException {
        File contentIOStorageDir = FileUtils.getFile((File)RuntimeConfig.getInstance().getAmetysHome(), (String[])new String[]{CONTENTIO_STORAGE_DIRECTORY});
        if (!contentIOStorageDir.exists() && !contentIOStorageDir.mkdirs()) {
            throw new IOException("Unable to create monitoring directory: " + String.valueOf(contentIOStorageDir));
        }
        Files.copy(path, Paths.get(contentIOStorageDir.getPath(), importId + ".csv"), StandardCopyOption.REPLACE_EXISTING);
    }

    private CsvPreference _getCSVPreference(String escapingChar, String separatingChar) {
        char escaping;
        char separating = separatingChar.charAt(0);
        if (separating == (escaping = escapingChar.charAt(0))) {
            throw new IllegalArgumentException("Separating character can not be equals to escaping character");
        }
        return new CsvPreference.Builder(escaping, (int)separating, "\r\n").build();
    }

    private List<Map<String, Object>> _getWorkflows() {
        String[] workflowNames;
        ArrayList<Map<String, Object>> workflows = new ArrayList<Map<String, Object>>();
        for (String workflowName : workflowNames = this._workflowHelper.getWorkflowNames()) {
            HashMap<String, String> workflowMap = new HashMap<String, String>();
            workflowMap.put("value", workflowName);
            workflowMap.put("label", (String)this._workflowHelper.getWorkflowLabel(workflowName));
            workflows.add(workflowMap);
        }
        return workflows;
    }
}

