/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.export.sql;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;

public class NormalizeNameComponent
extends AbstractLogEnabled
implements Component,
Contextualizable {
    public static final String ROLE = NormalizeNameComponent.class.getName();
    protected Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    protected String normalizedTableName(String prefix, String mappingPolicy, String initialTableName, Connection connection) {
        Map<String, String> mappingTableName = this.getMappingTableNameFromCache();
        if (mappingTableName.containsKey(initialTableName)) {
            return mappingTableName.get(initialTableName);
        }
        String initialTableNameNoPrefix = initialTableName.substring(prefix.length());
        Object normalizedTableName = initialTableNameNoPrefix.replace("-", "_");
        StringBuilder changedInitialName = new StringBuilder();
        int i = 0;
        for (String name : ((String)normalizedTableName).split("_")) {
            if (i != 0) {
                changedInitialName.append("_");
            }
            changedInitialName.append(this.normalizeNameFromPolicy(mappingPolicy, StringUtils.capitalize((String)name)));
            ++i;
        }
        normalizedTableName = prefix + changedInitialName.toString();
        int maxLength = Integer.MAX_VALUE;
        String datatype = ConnectionHelper.getDatabaseType((Connection)connection);
        if (datatype.equals("mysql")) {
            maxLength = 64;
        } else if (datatype.equals("oracle")) {
            maxLength = 30;
        }
        if (((String)normalizedTableName).length() >= maxLength) {
            int hashSize = 6;
            normalizedTableName = ((String)normalizedTableName).substring(0, maxLength - 6) + String.valueOf((int)Math.abs((double)((String)normalizedTableName).hashCode() % Math.pow(10.0, 6.0)));
        }
        if (mappingTableName.containsValue(normalizedTableName)) {
            normalizedTableName = StringUtils.substring((String)normalizedTableName, (int)0, (int)(((String)normalizedTableName).length() - 2)) + "_" + this._getCountSameValue((String)normalizedTableName, mappingTableName, 1);
        }
        mappingTableName.put(initialTableName, (String)normalizedTableName);
        return normalizedTableName;
    }

    protected String normalizedColumnName(String mappingPolicy, String initialColumnName, String initialTableName, Map<String, Map<String, String>> reservedWords, Connection connection) {
        Map<String, String> oracleReservedWords;
        String datatype = ConnectionHelper.getDatabaseType((Connection)connection);
        String columnName = initialColumnName;
        if (datatype.equals("mysql")) {
            Map<String, String> mysqlReservedWords = reservedWords.get("mysql");
            if (mysqlReservedWords.containsKey(StringUtils.upperCase((String)initialColumnName))) {
                columnName = StringUtils.lowerCase((String)mysqlReservedWords.get(StringUtils.upperCase((String)initialColumnName)));
            }
        } else if (datatype.equals("oracle") && (oracleReservedWords = reservedWords.get("oracle")).containsKey(StringUtils.upperCase((String)initialColumnName))) {
            columnName = StringUtils.lowerCase((String)oracleReservedWords.get(StringUtils.upperCase((String)initialColumnName)));
        }
        Map<String, HashMap<String, String>> mappingTableColumnName = this.getMappingTableColumnNameFromCache();
        HashMap<Object, Object> mappingColumnName = new HashMap();
        if (!mappingTableColumnName.containsKey(initialTableName)) {
            mappingTableColumnName.put(initialTableName, mappingColumnName);
        }
        if ((mappingColumnName = mappingTableColumnName.get(initialTableName)).containsKey(columnName)) {
            return (String)mappingColumnName.get(columnName);
        }
        Object normalizedColumnName = columnName.replace("-", "_");
        StringBuilder changedInitialName = new StringBuilder();
        int i = 0;
        for (String name : ((String)normalizedColumnName).split("_")) {
            if (i != 0) {
                changedInitialName.append("_");
            }
            changedInitialName.append(this.normalizeNameFromPolicy(mappingPolicy, StringUtils.capitalize((String)name)));
            ++i;
        }
        normalizedColumnName = changedInitialName.toString();
        int maxLength = Integer.MAX_VALUE;
        if (datatype.equals("mysql")) {
            maxLength = 64;
        } else if (datatype.equals("oracle")) {
            maxLength = 30;
        }
        if (((String)normalizedColumnName).length() > maxLength) {
            int hashSize = 9;
            normalizedColumnName = ((String)normalizedColumnName).substring(0, maxLength - 9) + String.valueOf((int)Math.abs((double)((String)normalizedColumnName).hashCode() % Math.pow(10.0, 9.0)));
        }
        if (mappingColumnName.containsValue(normalizedColumnName)) {
            normalizedColumnName = StringUtils.substring((String)normalizedColumnName, (int)0, (int)(((String)normalizedColumnName).length() - 2)) + "_" + this._getCountSameValue((String)normalizedColumnName, mappingColumnName, 1);
        }
        mappingColumnName.put(columnName, normalizedColumnName);
        return normalizedColumnName;
    }

    private int _getCountSameValue(String value, Map<String, String> mappingTable, int count) {
        Object valueAux = value;
        int countAux = count;
        for (String val : mappingTable.values()) {
            if (!val.equals(valueAux)) continue;
            valueAux = StringUtils.substring((String)valueAux, (int)0, (int)(((String)valueAux).length() - 2)) + "_" + ++countAux;
            return this._getCountSameValue((String)valueAux, mappingTable, countAux);
        }
        return countAux;
    }

    protected String normalizedComment(String initialComment, int maxLength, Connection connection) {
        Object normalizedComment = this.escapeValue(initialComment, connection);
        if (maxLength != 0 && ((String)normalizedComment).length() > maxLength) {
            normalizedComment = ((String)normalizedComment).substring(0, maxLength - 3) + "...";
        }
        return normalizedComment;
    }

    protected String escapeValue(String value, Connection connection) {
        String newValue = value;
        String datatype = ConnectionHelper.getDatabaseType((Connection)connection);
        if (datatype.equals("mysql")) {
            newValue = value.replace("'", "\\'");
        } else if (datatype.equals("oracle")) {
            newValue = value.replace("'", "''");
        }
        return newValue;
    }

    protected Map<String, String> getMappingTableNameFromCache() {
        Request request = ContextHelper.getRequest((Context)this._context);
        HashMap<String, String> mappingTableName = new HashMap();
        if (request.getAttribute("mappingTableName") != null) {
            mappingTableName = (Map)request.getAttribute("mappingTableName");
        } else {
            request.setAttribute("mappingTableName", mappingTableName);
        }
        return mappingTableName;
    }

    protected Map<String, HashMap<String, String>> getMappingTableColumnNameFromCache() {
        Request request = ContextHelper.getRequest((Context)this._context);
        HashMap<String, HashMap<String, String>> mappingTableColumnName = new HashMap();
        if (request.getAttribute("mappingTableColumnName") != null) {
            mappingTableColumnName = (Map)request.getAttribute("mappingTableColumnName");
        } else {
            request.setAttribute("mappingTableColumnName", mappingTableColumnName);
        }
        return mappingTableColumnName;
    }

    protected String normalizeNameFromPolicy(String mappingPolicy, String initialName) {
        String modifiedName = "";
        if (mappingPolicy.equals("FULL")) {
            modifiedName = initialName;
        } else if (mappingPolicy.equals("CAMELCASE")) {
            modifiedName = initialName.replaceAll("(\\p{Ll})(\\p{Lu})", "$1 $2");
            modifiedName = WordUtils.initials((String)modifiedName);
        } else if (mappingPolicy.equals("FIRSTCHAR")) {
            modifiedName = initialName.replaceAll("(\\p{Ll})(\\p{Lu})", "$1 $2");
            String[] words = modifiedName.split(" ");
            StringBuilder finalName = new StringBuilder();
            block0: for (String word : words) {
                if (word.length() > 3) {
                    for (int i = 3; i < word.length(); ++i) {
                        char charWord = word.charAt(i);
                        if (Character.isUpperCase(charWord) || charWord == 'a' || charWord == 'e' || charWord == 'i' || charWord == 'o' || charWord == 'u' || charWord == 'y') {
                            finalName.append(word.substring(0, i));
                            continue block0;
                        }
                        if (i != word.length() - 1) continue;
                        finalName.append(word);
                    }
                    continue;
                }
                finalName.append(word);
            }
            modifiedName = finalName.toString();
        }
        return modifiedName;
    }
}

