/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button for adding a task.
 * One of the parameters of the schedulable must be named 'collectionId', be of type 'string' and expect the id of a collection
 * @private
 */
Ext.define('Ametys.plugins.contentio.export.ExportButtonController', {
    extend: 'Ametys.plugins.coreui.schedule.AddTaskButtonController',
    
    constructor: function(config)
    {
        this.callParent(arguments);
        
        this.serverCall(
    		'hasDataSource',
    		[],
    		function(hasData)
    		{
    			if (!hasData)
    			{
    				this.disable();
    				this.setDescription("{{i18n PLUGINS_CONTENTIO_CONTENT_EXPORT_SQL_NO_DATASOURCE_MSG}}");
    			}
    		},
    		this
		);
    }
});
