<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2014 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:variable name="nl"><xsl:text>
</xsl:text></xsl:variable>
    
    <xsl:template match="/">
        <text>
            <xsl:choose>
                <!-- Success -->
                <xsl:when test="/import/@success = 'true'">
                    <i18n:text i18n:key="PLUGINS_CONTENTIO_IMPORTFILE_MAIL_BODY_START" i18n:catalogue="plugin.contentio"/>
                    
                    <xsl:for-each select="import/content">
                        <xsl:value-of select="concat(' * ', @title, ' (', /contents/@baseUrl, '/index.html?uitool=uitool-content,id:%27', @id, '%27)')"/>
                        <xsl:value-of select="$nl"/>
                    </xsl:for-each>
                    
                    <i18n:text i18n:key="PLUGINS_CONTENTIO_IMPORTFILE_MAIL_BODY_END" i18n:catalogue="plugin.contentio"/>
                </xsl:when>
                
                <!-- Error -->
                <xsl:otherwise>
                    <i18n:text i18n:key="PLUGINS_CONTENTIO_IMPORTFILE_ERROR_TEXT" i18n:catalogue="plugin.contentio"/>
                    <xsl:value-of select="concat($nl, $nl)"/>
                    
                    <xsl:choose>
                        <xsl:when test="/import/@error = 'no-importer'">
                            <i18n:text i18n:key="PLUGINS_CONTENTIO_IMPORTFILE_ERROR_NOIMPORTER" i18n:catalogue="plugin.contentio"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <i18n:text i18n:key="PLUGINS_CONTENTIO_IMPORTFILE_ERROR_SEE_LOGS" i18n:catalogue="plugin.contentio"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
        </text>
    </xsl:template>
    
</xsl:stylesheet>
